/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import ruukas.infinityeditor.data.InfinityConfig;
import ruukas.infinityeditor.gui.action.GuiInfinityButton;

@SideOnly(value=Side.CLIENT)
public class GuiNBT
extends GuiScreen {
    private final ItemStack stack;
    private final GuiScreen lastScreen;
    private GuiInfinityButton updateNbtButton;
    private GuiInfinityButton backButton;
    private GuiInfinityButton resetButton;
    private GuiInfinityButton[] colorButtons;
    private GuiTextField nbtTextField;
    protected String title = I18n.func_135052_a((String)"gui.nbt", (Object[])new Object[0]);
    protected ArrayList<String> prettyNBTList = new ArrayList();
    private String feedback = "";
    private boolean good = false;

    public GuiNBT(GuiScreen lastScreen, ItemStack stack) {
        this.lastScreen = lastScreen;
        this.stack = stack;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.nbtTextField = new GuiTextField(100, this.field_146289_q, this.field_146294_l / 4, 80, this.field_146294_l / 2, 16);
        this.nbtTextField.func_146203_f(20000);
        this.nbtTextField.func_146180_a(this.stack.func_77942_o() ? Objects.requireNonNull(this.stack.func_77978_p()).toString() : "{}");
        this.updateNbtButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(105, 3 * this.field_146294_l / 7, 100, this.field_146294_l / 7, 20, I18n.func_135052_a((String)"gui.nbt.update", (Object[])new Object[0])));
        this.backButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(200, this.field_146294_l / 2 - 60, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0])));
        this.resetButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(201, this.field_146294_l / 2, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.reset", (Object[])new Object[0])));
        TextFormatting[] formats = TextFormatting.values();
        int colorAmount = 2 + formats.length;
        this.colorButtons = new GuiInfinityButton[colorAmount];
        this.colorButtons[0] = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(130, this.field_146294_l - 1 - 13 * ((colorAmount + 2) / 2) + 13, this.field_146295_m - 30, 13, 15, formats[0].toString().substring(0, 1)));
        this.colorButtons[1] = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(131, this.field_146294_l - 1 - 13 * ((colorAmount + 2) / 2) + 26, this.field_146295_m - 30, 13, 15, TextFormatting.DARK_RED + "%"));
        for (int i = 2; i < colorAmount; ++i) {
            TextFormatting f = formats[i - 2];
            this.colorButtons[i] = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(130 + i, this.field_146294_l - 1 - 13 * ((colorAmount + 2) / 2) + 13 * (i % (colorAmount / 2) + 1), this.field_146295_m - 30 + 15 * (i / (colorAmount / 2)), 13, 15, f.toString() + f.toString().substring(1)));
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        this.nbtTextField.func_146178_a();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a(this.backButton);
        } else if (keyCode == 28 || keyCode == 156) {
            this.func_146284_a(this.updateNbtButton);
        } else {
            this.nbtTextField.func_146201_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nbtTextField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.updateNbtButton.field_146127_k) {
            try {
                this.stack.func_77982_d(JsonToNBT.func_180713_a((String)this.nbtTextField.func_146179_b()));
                this.good = true;
                this.feedback = "Looks good";
            }
            catch (NBTException nbtexception) {
                this.good = false;
                this.feedback = nbtexception.getMessage();
            }
        } else if (button.field_146127_k == this.backButton.field_146127_k) {
            this.field_146297_k.func_147108_a(this.lastScreen);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (button.field_146127_k >= 130 && button.field_146127_k < 130 + this.colorButtons.length) {
            GuiTextField f = this.nbtTextField;
            if (f.func_146206_l()) {
                if (button.field_146127_k == 130) {
                    f.func_146180_a(f.func_146179_b().substring(0, f.func_146198_h()) + TextFormatting.values()[0].toString().charAt(0) + f.func_146179_b().substring(f.func_146198_h()));
                } else if (button.field_146127_k == 131) {
                    f.func_146180_a(Objects.requireNonNull(TextFormatting.func_110646_a((String)f.func_146179_b())));
                } else {
                    f.func_146180_a(f.func_146179_b().substring(0, f.func_146198_h()) + TextFormatting.values()[button.field_146127_k - 132] + f.func_146179_b().substring(f.func_146198_h()));
                }
            }
        } else if (button.field_146127_k == this.resetButton.field_146127_k && this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179094_E();
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        this.func_146285_a(this.stack, 0, 25);
        String s = this.stack.func_77942_o() ? Objects.requireNonNull(this.stack.func_77978_p()).toString() : "{}";
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(s);
        s = gson.toJson(je);
        this.prettyNBTList.clear();
        Collections.addAll(this.prettyNBTList, s.split("\\n"));
        this.func_146283_a(this.prettyNBTList, 0, this.field_146295_m);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        this.field_146296_j.func_180450_b(this.stack, this.field_146294_l / 2 - 8, 30);
        GlStateManager.func_179121_F();
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 15, InfinityConfig.MAIN_COLOR);
        this.func_73732_a(this.field_146289_q, this.feedback, this.field_146294_l / 2, 130, this.good ? 5420856 : 16007778);
        this.nbtTextField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public boolean func_73868_f() {
        return false;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }
}

