/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.village.MerchantRecipe;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruukas.infinityeditor.data.InfinityConfig;
import ruukas.infinityeditor.gui.GuiInfinity;
import ruukas.infinityeditor.gui.GuiVillagerTrade;
import ruukas.infinityeditor.gui.HelperGui;
import ruukas.infinityeditor.gui.MerchantRecipeHolderList;
import ruukas.infinityeditor.util.MerchantRecipeUtil;

@SideOnly(value=Side.CLIENT)
public class GuiVillagerTrades
extends GuiInfinity {
    private MerchantRecipeHolderList buyingList;

    public GuiVillagerTrades(GuiScreen lastScreen, GuiInfinity.ItemStackHolder stackHolder) {
        super(lastScreen, stackHolder);
        this.setRenderStack(true, this.midX, 35, 1.0f);
        NBTTagCompound entityTag = this.getItemStack().func_190925_c("EntityTag");
        if (!entityTag.func_150297_b("Offers", 10)) {
            entityTag.func_74782_a("Offers", (NBTBase)new NBTTagCompound());
        }
        this.buyingList = new MerchantRecipeHolderList(entityTag.func_74775_l("Offers"));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        NBTTagCompound recs = this.buyingList.getRecipiesAsTags();
        if (!recs.func_82582_d()) {
            this.getItemStack().func_190925_c("EntityTag").func_74782_a("Offers", (NBTBase)recs);
        }
    }

    @Override
    protected void reset() {
        this.buyingList.clear();
        this.func_146281_b();
    }

    public void func_146281_b() {
        super.func_146281_b();
        NBTTagCompound recs = this.buyingList.getRecipiesAsTags();
        this.getItemStack().func_190925_c("EntityTag").func_74782_a("Offers", (NBTBase)recs);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int addWidth;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0 && mouseButton != 1) {
            return;
        }
        int size = this.buyingList.size();
        boolean sel = false;
        for (int i = 0; i < size; ++i) {
            MerchantRecipeHolder rH = (MerchantRecipeHolder)this.buyingList.get(i);
            String rString = MerchantRecipeUtil.getMerchantRecipeDisplayString(rH.getMerchantRecipe());
            int rWidth = this.field_146289_q.func_78256_a(rString);
            if (!HelperGui.isMouseInRegion(mouseX, mouseY, this.midX - rWidth / 2, this.midY - 20 * (size + 1) / 2 + 20 * i, rWidth, 8)) continue;
            if (mouseButton == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiVillagerTrade(this, this.stackHolder, rH));
            }
            if (mouseButton != 1) break;
            this.buyingList.remove(i);
            break;
        }
        if (!sel && mouseButton == 0 && HelperGui.isMouseInRegion(mouseX, mouseY, this.midX - (addWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.villagertrades.addtrade", (Object[])new Object[0]))) / 2, this.midY - 20 * (size + 1) / 2 + 20 * size, addWidth, 8)) {
            this.buyingList.add(new MerchantRecipeHolder(new MerchantRecipe(new ItemStack(Items.field_151166_bC), Items.field_151166_bC)));
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int size = this.buyingList.size();
        boolean foundSel = false;
        for (int i = 0; i < size; ++i) {
            String rString = MerchantRecipeUtil.getMerchantRecipeDisplayString(((MerchantRecipeHolder)this.buyingList.get(i)).getMerchantRecipe());
            boolean sel = false;
            if (!foundSel) {
                int rWidth = this.field_146289_q.func_78256_a(rString);
                sel = foundSel = HelperGui.isMouseInRegion(mouseX, mouseY, this.midX - rWidth / 2, this.midY - 20 * (size + 1) / 2 + 20 * i, rWidth, 8);
            }
            this.func_73732_a(this.field_146289_q, rString, this.midX, this.midY - 20 * (size + 1) / 2 + 20 * i, sel ? InfinityConfig.CONTRAST_COLOR : InfinityConfig.MAIN_COLOR);
        }
        int addWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.villagertrades.addtrade", (Object[])new Object[0]));
        boolean inRegion = !foundSel && HelperGui.isMouseInRegion(mouseX, mouseY, this.midX - addWidth / 2, this.midY - 20 * (size + 1) / 2 + 20 * size, addWidth, 8);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.villagertrades.addtrade", (Object[])new Object[0]), this.midX, this.midY - 20 * (size + 1) / 2 + 20 * size, inRegion ? InfinityConfig.CONTRAST_COLOR : InfinityConfig.MAIN_COLOR);
        if (foundSel) {
            this.func_146283_a(new ArrayList<String>(Arrays.asList(I18n.func_135052_a((String)"gui.villagertrades.leftclick", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.villagertrades.rightclick", (Object[])new Object[0]))), mouseX, mouseY);
        } else {
            HelperGui.addTooltip(this.resetButton, mouseX, mouseY, I18n.func_135052_a((String)"gui.villagertrades.reset", (Object[])new Object[0]));
        }
    }

    @Override
    protected String getNameUnlocalized() {
        return "villagertrades";
    }

    public static class MerchantRecipeHolder {
        private MerchantRecipe rec;

        public MerchantRecipeHolder(MerchantRecipe rec) {
            this.rec = rec;
        }

        public MerchantRecipe getMerchantRecipe() {
            return this.rec;
        }

        public void setMerchantRecipe(MerchantRecipe rec) {
            this.rec = rec;
        }
    }
}

