/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.gui.action;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruukas.infinityeditor.data.InfinityConfig;

@SideOnly(value=Side.CLIENT)
public class GuiNumberField
extends Gui {
    private final int id;
    private final FontRenderer fontRenderer;
    public int x;
    public int y;
    public int width;
    public int height;
    public char[] digits;
    public int maxValue = Integer.MAX_VALUE;
    public int minValue = Integer.MIN_VALUE;
    private char[] allowed = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private boolean isNegative;
    private int cursorCounter;
    private boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private boolean isFocused;
    private boolean isEnabled = true;
    private int cursorPosition;
    private int enabledColor = InfinityConfig.MAIN_COLOR;
    private int cursorColor = InfinityConfig.CONTRAST_COLOR;
    private int disabledColor = 0x707070;
    private boolean visible = true;
    public Runnable action;

    public GuiNumberField(int componentId, FontRenderer fontrendererObj, int x, int y, int width, int height, int digits) {
        this.id = componentId;
        this.fontRenderer = fontrendererObj;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.digits = new char[digits];
        this.resetDigits();
    }

    public String getValueAsString() {
        return (this.isNegative ? Character.valueOf('-') : "") + new String(this.digits);
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void setDigit(int i, char c) {
        if (this.isAllowed(c)) {
            this.digits[i] = c;
        }
        if (this.getIntValue() > this.maxValue) {
            int diff;
            String maxStr = this.maxValue + "";
            char mC = maxStr.charAt(this.cursorPosition - (diff = this.digits.length - maxStr.length()));
            if (c == mC) {
                this.setValue(this.maxValue);
            } else {
                this.setDigit(mC);
            }
        } else if (this.getIntValue() < this.minValue) {
            int diff;
            String minStr = this.minValue + "";
            StringBuilder zeroes = new StringBuilder();
            int neededZeroes = this.digits.length - minStr.length();
            for (int z = 0; z < neededZeroes; ++z) {
                zeroes.append("0");
            }
            minStr = zeroes + minStr;
            char mC = minStr.charAt(this.cursorPosition - (diff = this.digits.length - minStr.length()));
            if (c == mC) {
                this.setValue(this.minValue);
            } else {
                this.setDigit(mC);
            }
        }
        if (this.action != null) {
            this.action.run();
        }
    }

    public void setDigit(char c) {
        this.setDigit(this.cursorPosition, c);
    }

    public void setValue(int value) {
        boolean neg = value < 0;
        String s = ("" + value).substring(neg ? 1 : 0);
        int diff = this.getValueAsString().length() - s.length();
        if (diff < 0) {
            return;
        }
        this.resetDigits();
        for (int i = 0; i < s.length(); ++i) {
            this.digits[diff + i] = s.charAt(i);
        }
    }

    public void resetDigits() {
        for (int i = 0; i < this.digits.length; ++i) {
            this.digits[i] = 48;
        }
    }

    public int getIntValue() {
        return Integer.parseInt(this.getValueAsString());
    }

    public boolean isAllowed(char c) {
        for (char ch : this.allowed) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public void moveCursor(boolean right) {
        this.setCursorPosition(this.cursorPosition + (right ? 1 : -1));
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = pos;
        int i = this.digits.length - 1;
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)i);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.digits.length - 1);
    }

    public boolean textboxKeyTyped(char typedChar, int keyCode) {
        if (!this.isFocused) {
            return false;
        }
        if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)String.valueOf(this.digits));
            return true;
        }
        if (GuiScreen.func_175279_e((int)keyCode)) {
            return true;
        }
        if (GuiScreen.func_175277_d((int)keyCode)) {
            GuiScreen.func_146275_d((String)String.valueOf(this.digits));
            if (this.isEnabled) {
                this.resetDigits();
            }
            return true;
        }
        switch (keyCode) {
            case 14: 
            case 211: {
                if (this.isEnabled) {
                    this.setDigit('0');
                }
                return true;
            }
            case 199: {
                this.setCursorPositionZero();
                return true;
            }
            case 203: {
                this.moveCursor(false);
                return true;
            }
            case 205: {
                this.moveCursor(true);
                return true;
            }
            case 207: {
                this.setCursorPositionEnd();
                return true;
            }
        }
        if (this.isEnabled) {
            if (typedChar == '-' && this.minValue < 0) {
                this.isNegative = true;
            } else if (typedChar == '+' && this.maxValue > -1) {
                this.isNegative = false;
            } else if (this.isAllowed(typedChar)) {
                this.setDigit(typedChar);
                this.moveCursor(true);
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag;
        boolean bl = flag = mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        if (this.canLoseFocus) {
            this.setFocused(flag);
        }
        if (this.isFocused && flag && mouseButton == 0) {
            int i = mouseX - this.x;
            if (this.enableBackgroundDrawing) {
                i -= 4;
            }
            String s = this.fontRenderer.func_78269_a(this.getValueAsString(), this.getWidth());
            this.setCursorPosition(this.fontRenderer.func_78269_a(s, i).length());
            return true;
        }
        return false;
    }

    public void drawTextBox() {
        if (this.getVisible()) {
            int color;
            int n = color = this.isEnabled ? this.enabledColor : this.disabledColor;
            if (this.getEnableBackgroundDrawing()) {
                GuiNumberField.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)color);
                GuiNumberField.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)InfinityConfig.ALT_COLOR);
            }
            int cursorPos = this.cursorPosition;
            String string = this.fontRenderer.func_78269_a(this.getValueAsString(), this.getWidth());
            boolean cursorFine = cursorPos >= 0 && cursorPos <= string.length();
            boolean displayCursor = this.isFocused && this.cursorCounter / 6 % 2 == 0 && cursorFine;
            int textX = this.enableBackgroundDrawing ? this.x + 4 : this.x;
            int textY = this.enableBackgroundDrawing ? this.y + (this.height - 8) / 2 : this.y;
            int halfX = textX;
            if (!string.isEmpty()) {
                String halfString = cursorFine ? string.substring(0, cursorPos) : string;
                halfX = this.fontRenderer.func_175063_a(halfString, (float)textX, (float)textY, color) - 1;
            }
            int cursorX = halfX;
            if (!cursorFine) {
                int n2 = cursorX = cursorPos > 0 ? textX + this.width : textX;
            }
            if (!string.isEmpty() && cursorFine && cursorPos < string.length()) {
                halfX = this.fontRenderer.func_175063_a(string.substring(cursorPos), (float)halfX, (float)textY, color);
            }
            if (displayCursor) {
                this.fontRenderer.func_175063_a("_", (float)cursorX, (float)textY, this.cursorColor);
            }
        }
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public void setEnableBackgroundDrawing(boolean enableBackgroundDrawingIn) {
        this.enableBackgroundDrawing = enableBackgroundDrawingIn;
    }

    public void setTextColor(int color) {
        this.enabledColor = color;
    }

    public void setDisabledTextColour(int color) {
        this.disabledColor = color;
    }

    public void setFocused(boolean isFocusedIn) {
        if (isFocusedIn && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = isFocusedIn;
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_193975_a(isFocusedIn);
        }
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public int getWidth() {
        return this.getEnableBackgroundDrawing() ? this.width - 6 : this.width;
    }

    public void setCanLoseFocus(boolean canLoseFocusIn) {
        this.canLoseFocus = canLoseFocusIn;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }
}

