/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.gui.monsteregg;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import ruukas.infinityeditor.gui.monsteregg.MobTag;

public class MobTagSlider
extends MobTag {
    protected float min;
    protected float max;
    protected float step;
    protected float normal;

    public MobTagSlider(String name, String key, float min, float max, float step) {
        this(name, key, min, max, step, min);
    }

    public MobTagSlider(String name, String key, float min, float max, float step, float normal) {
        super(name, key);
        this.setMin(min);
        this.setMax(max);
        this.setStep(step);
    }

    public float getFloat(ItemStack stack) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_150297_b("EntityTag", 10) && stack.func_179543_a("EntityTag").func_150297_b(this.key, 5)) {
            return stack.func_179543_a("EntityTag").func_74760_g(this.key);
        }
        return this.min;
    }

    public void setValue(ItemStack stack, float f) {
        if (stack == null) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_150297_b("EntityTag", 10)) {
            stack.func_77978_p().func_74782_a("EntityTag", (NBTBase)new NBTTagCompound());
        }
        stack.func_179543_a("EntityTag").func_74776_a(this.key, f);
    }

    public String getKey() {
        return this.key;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public float getStep() {
        return this.step;
    }

    public void setStep(float step) {
        this.step = step;
    }

    public float normalizeValue(float value) {
        return MathHelper.func_76131_a((float)((this.snapToStepClamp(value) - this.min) / (this.max - this.min)), (float)0.0f, (float)1.0f);
    }

    public float denormalizeValue(float value) {
        return this.snapToStepClamp(this.min + (this.max - this.min) * MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f));
    }

    public float snapToStepClamp(float value) {
        value = this.snapToStep(value);
        return MathHelper.func_76131_a((float)value, (float)this.min, (float)this.max);
    }

    private float snapToStep(float value) {
        if (this.step > 0.0f) {
            value = this.step * (float)Math.round(value / this.step);
        }
        return value;
    }
}

