/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.gui.nbt;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import ruukas.infinityeditor.gui.GuiNBTAdvanced;
import ruukas.infinityeditor.gui.HelperGui;
import ruukas.infinityeditor.gui.nbt.NBTListElement;
import ruukas.infinityeditor.gui.nbt.NBTListRoot;

public class NBTListCompound
extends NBTListElement {
    protected List<NBTListElement> children;
    protected boolean closed = true;
    public static ItemStack openIcon = new ItemStack((Block)Blocks.field_150486_ae);
    public static ItemStack closedIcon = new ItemStack(Blocks.field_150477_bB);

    public NBTListCompound(String key, NBTTagCompound tag, boolean closed, int x, int y) {
        this(key, tag, closed ? closedIcon : openIcon, x, y);
        this.closed = closed;
    }

    public NBTListCompound(String key, NBTTagCompound tag, ItemStack iconStack, int x, int y) {
        super(key, (NBTBase)tag, iconStack, x, y);
        if (tag != null) {
            this.children = new ArrayList<NBTListElement>();
            int length = 20;
            for (String childKey : tag.func_150296_c()) {
                NBTBase child = tag.func_74781_a(childKey);
                int lengthToAdd = child instanceof NBTTagCompound ? this.addChild(new NBTListCompound(childKey, (NBTTagCompound)child, closedIcon, x + 15, y + length)) : this.addChild(new NBTListElement(childKey, child, new ItemStack(Items.field_151121_aF), x + 15, y + length));
                length += lengthToAdd;
            }
        }
    }

    public int addChild(NBTListElement child) {
        child.parent = this;
        this.children.add(child);
        return child instanceof NBTListCompound ? ((NBTListCompound)child).getLength() + 20 : 20;
    }

    public NBTTagCompound getTagCompound() {
        return (NBTTagCompound)this.tag;
    }

    @Override
    public String getText() {
        return this.children != null ? this.getKey() + " (" + this.children.size() + ")" : this.getKey();
    }

    @Override
    public String getTypeName() {
        return "Compound Tag";
    }

    @Override
    public void drawIcon(RenderItem itemRender) {
        super.drawIcon(itemRender);
        if (this.closed) {
            return;
        }
        if (this.tag != null && !this.children.isEmpty()) {
            for (NBTListElement e : this.children) {
                e.drawIcon(itemRender);
            }
        }
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        int length;
        super.draw(mc, mouseX, mouseY);
        if (!(this instanceof NBTListRoot) && this.isMouseOver(mouseX, mouseY)) {
            GuiNBTAdvanced.setInfoStatic(I18n.func_135052_a((String)(this.closed ? "gui.nbt.comp.open" : "gui.nbt.comp.close"), (Object[])new Object[0]), HelperGui.getColorFromRGB(255, 230, 115, 30));
        }
        if (this.closed) {
            return;
        }
        if (this.tag != null) {
            for (NBTListElement e : this.children) {
                NBTListCompound.drawHorizontalStructureLine(e.getX() - 13, e.getY(), 11);
                e.draw(mc, mouseX, mouseY);
            }
        }
        if ((length = this.getLength()) > 0) {
            NBTListCompound.drawVerticalStructureLine(this.getX(), this.getY(), this.getLength());
        }
    }

    public List<NBTListCompound> getCompoundChildren() {
        ArrayList<NBTListCompound> compounds = new ArrayList<NBTListCompound>();
        for (NBTListElement c : this.children) {
            if (!(c instanceof NBTListCompound)) continue;
            compounds.add((NBTListCompound)c);
        }
        return compounds;
    }

    public int getLength() {
        if (!this.closed && this.getTagCompound() != null) {
            int length = this.getTagCompound().func_186856_d() * 20;
            for (NBTListCompound c : this.getCompoundChildren()) {
                length += c.getLength();
            }
            return length;
        }
        return 0;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this instanceof NBTListRoot) {
            return;
        }
        if (this.isMouseOver(mouseX, mouseY) && mouseButton == 0) {
            this.closed = !this.closed;
            this.icon = this.closed ? closedIcon : openIcon;
            ((NBTListCompound)this.getRoot()).redoPositions();
        } else if (!this.closed && this.children != null && !this.children.isEmpty()) {
            for (NBTListElement e : this.children) {
                e.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }
    }

    public void redoPositions() {
        int length = 20;
        for (NBTListElement e : this.children) {
            e.setY(this.getY() + length);
            length += 20;
            if (!(e.tag instanceof NBTTagCompound)) continue;
            NBTListCompound tag = (NBTListCompound)e;
            length += tag.getLength();
            tag.redoPositions();
        }
    }
}

