/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.gui.nbt;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import ruukas.infinityeditor.gui.GuiNBTAdvanced;
import ruukas.infinityeditor.gui.HelperGui;
import ruukas.infinityeditor.gui.nbt.NBTListCompound;
import ruukas.infinityeditor.gui.nbt.NBTListElement;
import ruukas.infinityeditor.gui.nbt.NBTOption;

public class NBTListRoot
extends NBTListCompound {
    private NBTListCompound tagElement;
    private NBTListElement focus = null;
    private NBTListElement selected = null;
    private int selX = 0;
    private int selY = 0;
    private int selWidth = 0;
    private int selHeight = 0;
    private NBTOption[] options = null;

    public NBTListRoot(ItemStack stack) {
        super(stack.func_82833_r(), (NBTTagCompound)null, stack, 30, 50);
        if (this.icon.func_77942_o()) {
            this.tagElement = new NBTListCompound("tag", this.icon.func_77978_p(), false, this.getX() + 15, this.getY() + 20);
            this.tagElement.parent = this;
        }
    }

    public NBTListElement getSelected() {
        return this.selected;
    }

    public void setSelected(NBTListElement e, int x, int y) {
        this.selected = e;
        this.selX = x;
        this.selY = y;
        this.options = this.selected.getOptions();
        this.selWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.selected.getTypeName());
        for (NBTOption o : this.options) {
            this.selWidth = Math.max(Minecraft.func_71410_x().field_71466_p.func_78256_a(o.getText()), this.selWidth);
        }
        this.selHeight = 12 * this.options.length + 15;
    }

    public void clearSelected() {
        this.selected = null;
        this.selX = 0;
        this.selY = 0;
        this.selWidth = 0;
        this.selHeight = 0;
        this.options = null;
    }

    public void setFocus(NBTListElement e) {
        if (e == this) {
            return;
        }
        this.focus = e;
    }

    @Override
    public void redoPositions() {
        this.tagElement.redoPositions();
    }

    @Override
    public void drawIcon(RenderItem itemRender) {
        super.drawIcon(itemRender);
        if (this.tagElement != null) {
            this.tagElement.drawIcon(itemRender);
        }
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        this.func_73731_b(mc.field_71466_p, this.getText(), this.getX() + 15, this.getY() - 5, 0xFFFFFF);
        if (this.tagElement != null) {
            NBTListRoot.drawVerticalStructureLine(this.getX(), this.getY(), 20);
            NBTListRoot.drawHorizontalStructureLine(this.getX() + 2, this.getY() + 20, 12);
            this.tagElement.draw(mc, mouseX, mouseY);
        }
        if (this.selected != null) {
            NBTListRoot.func_73734_a((int)this.selX, (int)this.selY, (int)(this.selX + this.selWidth + 6), (int)(this.selY + 13), (int)HelperGui.getColorFromRGB(180, 0, 120, 120));
            mc.field_71462_r.func_73731_b(mc.field_71466_p, this.selected.getTypeName(), this.selX + 3, this.selY + 3, HelperGui.getColorFromRGB(180, 180, 180, 180));
            int i = 1;
            for (NBTOption o : this.options) {
                boolean over = HelperGui.isMouseInRegion(mouseX, mouseY, this.selX, this.selY + 13 * i, this.selWidth + 6, 13);
                NBTListRoot.func_73734_a((int)this.selX, (int)(this.selY + 13 * i), (int)(this.selX + this.selWidth + 6), (int)(this.selY + 13 + 13 * i), (int)HelperGui.getColorFromRGB(180, 30, 30, 30));
                mc.field_71462_r.func_73731_b(mc.field_71466_p, o.getText(), this.selX + 3, this.selY + 3 + i * 13, over ? HelperGui.getColorFromRGB(180, 230, 115, 30) : HelperGui.getColorFromRGB(255, 180, 180, 180));
                ++i;
            }
        } else if (this.focus != null) {
            int width = GuiNBTAdvanced.windowWidth;
            int height = GuiNBTAdvanced.windowHeight;
            int focX = GuiNBTAdvanced.windowX + width / 3 * 2;
            int focY = GuiNBTAdvanced.windowY + 10;
            int focXEnd = width - 10;
            int focYEnd = GuiNBTAdvanced.windowX + height / 2 - 10;
            NBTListRoot.func_73734_a((int)focX, (int)focY, (int)focXEnd, (int)focYEnd, (int)HelperGui.getColorFromRGB(180, 50, 50, 50));
            int focWidth = focXEnd - focX;
            mc.field_71462_r.func_73732_a(mc.field_71466_p, mc.field_71466_p.func_78269_a(this.focus.getTypeName(), focWidth), focX + focWidth / 2, 60, HelperGui.getColorFromRGB(255, 230, 115, 30));
            mc.field_71462_r.func_73731_b(mc.field_71466_p, mc.field_71466_p.func_78269_a("Key: " + this.focus.getKey(), focWidth), focX + 10, 75, HelperGui.getColorFromRGB(255, 230, 115, 30));
            if (!(this.focus.tag instanceof NBTTagCompound)) {
                mc.field_71462_r.func_73731_b(mc.field_71466_p, mc.field_71466_p.func_78269_a("Value: " + this.focus.tag.toString(), focWidth), focX + 10, 90, HelperGui.getColorFromRGB(255, 230, 115, 30));
            }
        }
    }

    public boolean mouseOverSelected(int mouseX, int mouseY) {
        return this.selected != null && HelperGui.isMouseInRegion(mouseX, mouseY, this.selX, this.selY, this.selWidth, this.selHeight);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.selected != null) {
            if (this.mouseOverSelected(mouseX, mouseY)) {
                int y;
                if (mouseButton == 0 && (y = mouseY - (this.selY + 13)) >= 0) {
                    this.options[y / 13].action();
                }
            } else {
                this.clearSelected();
            }
            return;
        }
        if (this.tagElement != null) {
            this.tagElement.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public NBTOption[] getOptions() {
        return new NBTOption[]{this.getIconStack().func_77942_o() ? new NBTOption(){

            @Override
            public String getText() {
                return "Clear tag";
            }

            @Override
            public void action() {
                NBTListRoot.this.getIconStack().func_77982_d(null);
                NBTListRoot.this.tagElement = null;
                NBTListRoot.this.clearSelected();
            }
        } : new NBTOption(){

            @Override
            public String getText() {
                return "Create tag";
            }

            @Override
            public void action() {
                NBTListRoot.this.getIconStack().func_77982_d(new NBTTagCompound());
                NBTListRoot.this.tagElement = new NBTListCompound("tag", NBTListRoot.this.icon.func_77978_p(), false, NBTListRoot.this.getX() + 15, NBTListRoot.this.getY() + 20);
                ((NBTListRoot)NBTListRoot.this).tagElement.parent = NBTListRoot.this;
                NBTListRoot.this.clearSelected();
            }
        }};
    }
}

