/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.nbt;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.oredict.DyeUtils;
import org.apache.commons.lang3.StringUtils;

public class NBTHelper {
    public static ItemStack generateNote(String noteName, String ... lore) {
        ItemStack stack = new ItemStack(Items.field_151121_aF);
        stack.func_151001_c(noteName);
        if (lore != null) {
            NBTTagList loreTagList = new NBTTagList();
            for (String str : lore) {
                loreTagList.func_74742_a((NBTBase)new NBTTagString(str));
            }
            stack.func_77978_p().func_74775_l("display").func_74782_a("Lore", (NBTBase)loreTagList);
        }
        return stack;
    }

    public static void addLoreLine(ItemStack stack, String line) {
        NBTTagList lore = NBTHelper.getLoreTagList(stack);
        lore.func_74742_a((NBTBase)new NBTTagString(line));
    }

    public static void removeLoreLine(ItemStack stack, int index) {
        NBTTagList lore = NBTHelper.getLoreTagList(stack);
        if (index >= lore.func_74745_c()) {
            if (lore.func_74745_c() == 0) {
                NBTHelper.removeLore(stack);
            }
            return;
        }
        lore.func_74744_a(index);
        if (lore.func_74745_c() == 0) {
            NBTHelper.removeLore(stack);
        }
    }

    public static void editLoreLine(ItemStack stack, int index, String line) {
        NBTTagList lore = NBTHelper.getLoreTagList(stack);
        if (index >= lore.func_74745_c()) {
            NBTHelper.addLoreLine(stack, line);
        } else {
            lore.func_150304_a(index, (NBTBase)new NBTTagString(line));
        }
    }

    public static void removeLore(ItemStack stack) {
        NBTTagCompound displayTag = NBTHelper.getDisplayTag(stack);
        if (displayTag.func_150297_b("Lore", 9)) {
            displayTag.func_82580_o("Lore");
        }
        NBTHelper.removeDisplayTagIfEmpty(stack);
    }

    public static boolean hasLore(ItemStack stack) {
        return NBTHelper.hasDisplayTag(stack) && NBTHelper.getDisplayTag(stack).func_150297_b("Lore", 9);
    }

    public static NBTTagList getLoreTagList(ItemStack stack) {
        NBTTagCompound displayTag = NBTHelper.getDisplayTag(stack);
        if (!NBTHelper.hasLore(stack)) {
            displayTag.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        return displayTag.func_150295_c("Lore", 8);
    }

    @Nullable
    public static String getLoreLine(ItemStack stack, int line) {
        NBTTagList lore;
        if (NBTHelper.hasLore(stack) && line < (lore = NBTHelper.getLoreTagList(stack)).func_74745_c()) {
            return lore.func_150307_f(line);
        }
        return null;
    }

    public static NBTTagCompound getDisplayTag(ItemStack stack) {
        return stack.func_190925_c("display");
    }

    public static boolean hasDisplayTag(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("display", 10);
    }

    public static void removeDisplayTagIfEmpty(ItemStack stack) {
        if (NBTHelper.hasDisplayTag(stack) && NBTHelper.getDisplayTag(stack).func_82582_d()) {
            stack.func_77978_p().func_82580_o("display");
        }
        NBTHelper.removeTagCompoundIfEmpty(stack);
    }

    public static NBTTagCompound getEntityTag(ItemStack stack) {
        return stack.func_190925_c("EntityTag");
    }

    public static boolean hasEntityTag(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("EntityTag", 10);
    }

    public static void removeEntityTagIfEmpty(ItemStack stack) {
        if (NBTHelper.hasEntityTag(stack) && NBTHelper.getEntityTag(stack).func_82582_d()) {
            stack.func_77978_p().func_82580_o("EntityTag");
        }
        NBTHelper.removeTagCompoundIfEmpty(stack);
    }

    public static boolean isUnbreakable(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74767_n("Unbreakable");
    }

    public static void setUnbreakable(ItemStack stack, boolean b) {
        NBTHelper.setRootBoolean(stack, "Unbreakable", b);
    }

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    private static void setRootBoolean(ItemStack stack, String key, boolean b) {
        if (b) {
            NBTHelper.getTagCompound(stack).func_74757_a(key, b);
        } else if (stack.func_77942_o()) {
            NBTTagCompound tag = NBTHelper.getTagCompound(stack);
            tag.func_82580_o(key);
            NBTHelper.removeTagCompoundIfEmpty(stack);
        }
    }

    public static void removeTagCompoundIfEmpty(ItemStack stack) {
        if (NBTHelper.getTagCompound(stack).func_82582_d()) {
            stack.func_77982_d(null);
        }
    }

    public static class ArmorStandNBTHelper {
        public static final RootBoolean SHOW_ARMS = new EntityBoolean("ShowArms");
        public static final RootBoolean SMALL = new EntityBoolean("Small");
        public static final RootBoolean INVISIBLE = new EntityBoolean("Invisible");
        public static final RootBoolean NO_BASE = new EntityBoolean("NoBasePlate");
        public static final RootBoolean MARKER = new EntityBoolean("Marker");

        public static NBTTagCompound getPoseTag(ItemStack stack) {
            NBTTagCompound entityTag = NBTHelper.getEntityTag(stack);
            if (!entityTag.func_150297_b("Pose", 10)) {
                entityTag.func_74782_a("Pose", (NBTBase)new NBTTagCompound());
            }
            return entityTag.func_74775_l("Pose");
        }

        public static boolean hasPoseTag(ItemStack stack) {
            return NBTHelper.hasEntityTag(stack) && NBTHelper.getEntityTag(stack).func_150297_b("Pose", 10);
        }

        public static void removePoseTagIfEmpty(ItemStack stack) {
            if (ArmorStandNBTHelper.hasPoseTag(stack) && ArmorStandNBTHelper.getPoseTag(stack).func_82582_d()) {
                NBTHelper.getEntityTag(stack).func_82580_o("Pose");
            }
            NBTHelper.removeEntityTagIfEmpty(stack);
        }

        public static void setRotations(ItemStack stack, EnumPosePart part, float x, float y, float z) {
            NBTTagList rot = ArmorStandNBTHelper.getRotationsTag(stack, part);
            if (rot.func_82582_d()) {
                rot.func_74742_a((NBTBase)new NBTTagFloat(x));
                rot.func_74742_a((NBTBase)new NBTTagFloat(y));
                rot.func_74742_a((NBTBase)new NBTTagFloat(z));
            } else {
                rot.func_150304_a(0, (NBTBase)new NBTTagFloat(x));
                rot.func_150304_a(1, (NBTBase)new NBTTagFloat(y));
                rot.func_150304_a(2, (NBTBase)new NBTTagFloat(z));
            }
        }

        public static void setX(ItemStack stack, EnumPosePart part, float x) {
            ArmorStandNBTHelper.setRotations(stack, part, x, ArmorStandNBTHelper.getY(stack, part), ArmorStandNBTHelper.getZ(stack, part));
        }

        public static void setY(ItemStack stack, EnumPosePart part, float y) {
            ArmorStandNBTHelper.setRotations(stack, part, ArmorStandNBTHelper.getX(stack, part), y, ArmorStandNBTHelper.getZ(stack, part));
        }

        public static void setZ(ItemStack stack, EnumPosePart part, float z) {
            ArmorStandNBTHelper.setRotations(stack, part, ArmorStandNBTHelper.getX(stack, part), ArmorStandNBTHelper.getY(stack, part), z);
        }

        public static float getX(ItemStack stack, EnumPosePart part) {
            if (!ArmorStandNBTHelper.hasRotations(stack, part)) {
                return 0.0f;
            }
            return ArmorStandNBTHelper.getRotationsArray(stack, part)[0];
        }

        public static float getY(ItemStack stack, EnumPosePart part) {
            if (!ArmorStandNBTHelper.hasRotations(stack, part)) {
                return 0.0f;
            }
            return ArmorStandNBTHelper.getRotationsArray(stack, part)[1];
        }

        public static float getZ(ItemStack stack, EnumPosePart part) {
            if (!ArmorStandNBTHelper.hasRotations(stack, part)) {
                return 0.0f;
            }
            return ArmorStandNBTHelper.getRotationsArray(stack, part)[2];
        }

        public static NBTTagList getRotationsTag(ItemStack stack, EnumPosePart part) {
            NBTTagCompound poseTag = ArmorStandNBTHelper.getPoseTag(stack);
            if (!poseTag.func_150297_b(part.getKey(), 9)) {
                poseTag.func_74782_a(part.getKey(), (NBTBase)new NBTTagList());
            }
            return poseTag.func_150295_c(part.getKey(), 5);
        }

        public static float[] getRotationsArray(ItemStack stack, EnumPosePart part) {
            NBTTagList rot;
            if (ArmorStandNBTHelper.hasRotations(stack, part) && !(rot = ArmorStandNBTHelper.getRotationsTag(stack, part)).func_82582_d()) {
                return new float[]{rot.func_150308_e(0), rot.func_150308_e(1), rot.func_150308_e(2)};
            }
            return new float[]{0.0f, 0.0f, 0.0f};
        }

        public static boolean hasRotations(ItemStack stack, EnumPosePart part) {
            return ArmorStandNBTHelper.hasPoseTag(stack) && ArmorStandNBTHelper.getPoseTag(stack).func_150297_b(part.key, 9);
        }

        public static void removeRotationIfEmpty(ItemStack stack, EnumPosePart part) {
            NBTTagList rot;
            if (ArmorStandNBTHelper.hasRotations(stack, part) && ((rot = ArmorStandNBTHelper.getRotationsTag(stack, part)).func_82582_d() || rot.func_150308_e(0) == 0.0f && rot.func_150308_e(1) == 0.0f && rot.func_150308_e(2) == 0.0f)) {
                ArmorStandNBTHelper.getPoseTag(stack).func_82580_o(part.getKey());
            }
            ArmorStandNBTHelper.removePoseTagIfEmpty(stack);
        }
    }

    public static class ColorNBTHelper {
        public static boolean isPotion(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemPotion || stack.func_77973_b() instanceof ItemTippedArrow;
        }

        public static int getColorAsInt(ItemStack stack) {
            if (ColorNBTHelper.isPotion(stack)) {
                return PotionUtils.func_190932_c((ItemStack)stack);
            }
            if (stack.func_77973_b().func_77643_m_()) {
                return NBTHelper.hasDisplayTag(stack) ? NBTHelper.getDisplayTag(stack).func_74762_e("MapColor") : 0;
            }
            if (ColorNBTHelper.hasColor(stack)) {
                return NBTHelper.getDisplayTag(stack).func_74762_e("color");
            }
            if (ColorNBTHelper.applicableForColor(stack)) {
                return 10511680;
            }
            return 0;
        }

        public static boolean hasColor(ItemStack stack) {
            if (ColorNBTHelper.isPotion(stack)) {
                return stack.func_77942_o() && stack.func_77978_p().func_150297_b("CustomPotionColor", 3);
            }
            if (stack.func_77973_b().func_77643_m_()) {
                return NBTHelper.hasDisplayTag(stack) && NBTHelper.getDisplayTag(stack).func_150297_b("MapColor", 3);
            }
            return NBTHelper.hasDisplayTag(stack) && NBTHelper.getDisplayTag(stack).func_150297_b("color", 3);
        }

        public static boolean applicableForColor(ItemStack stack) {
            return ColorNBTHelper.isPotion(stack) || stack.func_77973_b().func_77643_m_() || stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER;
        }

        public static void setColor(ItemStack stack, int color) {
            if (ColorNBTHelper.isPotion(stack)) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("CustomPotionColor", color);
            } else {
                NBTHelper.getDisplayTag(stack).func_74768_a(stack.func_77973_b().func_77643_m_() ? "MapColor" : "color", color);
            }
        }

        public static int getRed(ItemStack stack) {
            return ColorNBTHelper.getColorAsInt(stack) >> 16 & 0xFF;
        }

        public static void setRed(ItemStack stack, int red) {
            int color = red << 16;
            color += ColorNBTHelper.getGreen(stack) << 8;
            ColorNBTHelper.setColor(stack, color += ColorNBTHelper.getBlue(stack));
        }

        public static int getGreen(ItemStack stack) {
            return ColorNBTHelper.getColorAsInt(stack) >> 8 & 0xFF;
        }

        public static void setGreen(ItemStack stack, int green) {
            int color = ColorNBTHelper.getRed(stack) << 16;
            color += green << 8;
            ColorNBTHelper.setColor(stack, color += ColorNBTHelper.getBlue(stack));
        }

        public static int getBlue(ItemStack stack) {
            return ColorNBTHelper.getColorAsInt(stack) & 0xFF;
        }

        public static void setBlue(ItemStack stack, int blue) {
            int color = ColorNBTHelper.getRed(stack) << 16;
            color += ColorNBTHelper.getGreen(stack) << 8;
            ColorNBTHelper.setColor(stack, color += blue);
        }

        public static void addDye(ItemStack stack, EnumDyeColor dye) {
            ItemStack itemstack = ItemStack.field_190927_a;
            int[] aint = new int[3];
            int i = 0;
            int j = 0;
            ItemArmor itemarmor = null;
            ItemStack[] stacks = new ItemStack[]{stack, new ItemStack(Items.field_151100_aR, 1, dye.func_176767_b())};
            for (int k = 0; k < 2; ++k) {
                ItemStack itemstack1 = stacks[k];
                if (itemstack1.func_190926_b()) continue;
                if (itemstack1.func_77973_b() instanceof ItemArmor) {
                    itemarmor = (ItemArmor)itemstack1.func_77973_b();
                    if (itemarmor.func_82812_d() != ItemArmor.ArmorMaterial.LEATHER || !itemstack.func_190926_b()) {
                        return;
                    }
                    itemstack = itemstack1;
                    itemstack.func_190920_e(1);
                    if (!itemarmor.func_82816_b_(itemstack1)) continue;
                    int l = itemarmor.func_82814_b(itemstack);
                    float f = (float)(l >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(l & 0xFF) / 255.0f;
                    i = (int)((float)i + Math.max(f, Math.max(f1, f2)) * 255.0f);
                    aint[0] = (int)((float)aint[0] + f * 255.0f);
                    aint[1] = (int)((float)aint[1] + f1 * 255.0f);
                    aint[2] = (int)((float)aint[2] + f2 * 255.0f);
                    ++j;
                    continue;
                }
                if (!DyeUtils.isDye((ItemStack)itemstack1)) {
                    return;
                }
                float[] afloat = ((EnumDyeColor)DyeUtils.colorFromStack((ItemStack)itemstack1).get()).func_193349_f();
                int l1 = (int)(afloat[0] * 255.0f);
                int i2 = (int)(afloat[1] * 255.0f);
                int j2 = (int)(afloat[2] * 255.0f);
                i += Math.max(l1, Math.max(i2, j2));
                aint[0] = aint[0] + l1;
                aint[1] = aint[1] + i2;
                aint[2] = aint[2] + j2;
                ++j;
            }
            if (itemarmor != null) {
                int i1 = aint[0] / j;
                int j1 = aint[1] / j;
                int k1 = aint[2] / j;
                float f3 = (float)i / (float)j;
                float f4 = Math.max(i1, Math.max(j1, k1));
                i1 = (int)((float)i1 * f3 / f4);
                j1 = (int)((float)j1 * f3 / f4);
                k1 = (int)((float)k1 * f3 / f4);
                int k2 = (i1 << 8) + j1;
                k2 = (k2 << 8) + k1;
                itemarmor.func_82813_b(itemstack, k2);
            }
        }
    }

    public static class SkullNBTHelper {
        public static GameProfile getSkullOwner(ItemStack stack) {
            GameProfile profile = null;
            if (stack.func_77942_o()) {
                NBTTagCompound nbttagcompound = stack.func_77978_p();
                if (nbttagcompound.func_150297_b("SkullOwner", 10)) {
                    profile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("SkullOwner"));
                } else if (nbttagcompound.func_150297_b("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)nbttagcompound.func_74779_i("SkullOwner"))) {
                    profile = new GameProfile(null, nbttagcompound.func_74779_i("SkullOwner"));
                }
            }
            return profile;
        }

        public static void setSkullOwner(ItemStack stack, String owner) {
            NBTHelper.getTagCompound(stack).func_74778_a("SkullOwner", owner);
        }
    }

    public static enum EnumPosePart {
        BODY("Body"),
        LEFT_ARM("LeftArm"),
        RIGHT_ARM("RightArm"),
        LEFT_LEG("LeftLeg"),
        RIGHT_LEG("RightLeg"),
        HEAD("Head");

        private final String key;

        private EnumPosePart(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class EntityBoolean
    extends RootBoolean {
        private EntityBoolean(String key) {
            super(key);
        }

        @Override
        public void switchValue(ItemStack stack) {
            this.setValue(stack, !this.getValue(stack));
        }

        @Override
        public boolean getValue(ItemStack stack) {
            return NBTHelper.hasEntityTag(stack) && NBTHelper.getEntityTag(stack).func_74767_n(this.key);
        }

        @Override
        public void setValue(ItemStack stack, boolean b) {
            if (b) {
                NBTHelper.getEntityTag(stack).func_74757_a(this.key, b);
            } else if (NBTHelper.hasEntityTag(stack)) {
                NBTTagCompound tag = NBTHelper.getEntityTag(stack);
                tag.func_82580_o(this.key);
                NBTHelper.removeEntityTagIfEmpty(stack);
            }
        }

        @Override
        public byte getByte(ItemStack stack) {
            if (NBTHelper.hasEntityTag(stack)) {
                return NBTHelper.getEntityTag(stack).func_74771_c(this.key);
            }
            return 0;
        }
    }

    public static class RootBoolean {
        protected final String key;

        private RootBoolean(String key) {
            this.key = key;
        }

        public void switchValue(ItemStack stack) {
            this.setValue(stack, !this.getValue(stack));
        }

        public boolean getValue(ItemStack stack) {
            return stack.func_77942_o() && NBTHelper.getTagCompound(stack).func_74767_n(this.key);
        }

        public void setValue(ItemStack stack, boolean b) {
            NBTHelper.setRootBoolean(stack, this.key, b);
        }

        public byte getByte(ItemStack stack) {
            if (stack.func_77942_o()) {
                return stack.func_77978_p().func_74771_c(this.key);
            }
            return 0;
        }
    }
}

