/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.nbt.itemstack.tag;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import ruukas.infinityeditor.nbt.itemstack.InfinityItemTag;

public class InfinityBookTags {
    private final InfinityItemTag itemTag;
    private static final String generationKey = "generation";
    private static final String authorKey = "author";
    private static final String titleKey = "title";
    private static final String pagesKey = "pages";
    private static final String resolvedKey = "resolved";

    public InfinityBookTags(InfinityItemTag itemTag) {
        this.itemTag = itemTag;
    }

    public InfinityBookTags(ItemStack stack) {
        this(new InfinityItemTag(stack));
    }

    public int getGeneration() {
        return this.itemTag.getTag().func_74762_e(generationKey);
    }

    public InfinityBookTags addGeneration() {
        int gen = (this.getGeneration() + 1) % 4;
        if (gen == 0) {
            this.itemTag.getTag().func_82580_o(generationKey);
            this.itemTag.checkEmpty();
        } else {
            this.itemTag.getTag().func_74768_a(generationKey, gen);
        }
        return this;
    }

    public String getAuthor() {
        return this.itemTag.getTag().func_74779_i(authorKey);
    }

    public InfinityBookTags setAuthor(String author) {
        this.itemTag.getTag().func_74778_a(authorKey, author);
        return this;
    }

    public InfinityBookTags clearAuthor() {
        this.itemTag.getTag().func_74782_a(authorKey, null);
        return this;
    }

    public String getTitle() {
        return this.itemTag.getTag().func_74779_i(titleKey);
    }

    public InfinityBookTags setTitle(String title) {
        this.itemTag.getTag().func_74778_a(titleKey, title);
        return this;
    }

    public InfinityBookTags clearTitle() {
        this.itemTag.getTag().func_74782_a(titleKey, null);
        return this;
    }

    public SignedData unsign() {
        SignedData data = new SignedData(this.itemTag.getTag());
        if (this.itemTag.getTag().func_150297_b(pagesKey, 9) || !this.itemTag.getTag().func_150295_c(pagesKey, 8).func_82582_d()) {
            NBTTagList pagesList = this.itemTag.getTag().func_150295_c(pagesKey, 8);
            for (int i = 0; i < pagesList.func_74745_c(); ++i) {
                try {
                    ITextComponent comp = ITextComponent.Serializer.func_150699_a((String)pagesList.func_150307_f(i));
                    pagesList.func_150304_a(i, (NBTBase)new NBTTagString(comp.func_150260_c()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.itemTag.getTag().func_82580_o(generationKey);
        this.itemTag.getTag().func_82580_o(authorKey);
        this.itemTag.getTag().func_82580_o(titleKey);
        this.itemTag.getTag().func_82580_o(resolvedKey);
        this.itemTag.checkEmpty();
        return data;
    }

    public InfinityBookTags resign(SignedData data) {
        this.itemTag.getTag().func_74782_a(pagesKey, (NBTBase)data.pages);
        this.itemTag.getTag().func_74768_a(generationKey, data.generation);
        this.itemTag.getTag().func_74778_a(authorKey, data.author);
        this.itemTag.getTag().func_74778_a(titleKey, data.title);
        this.itemTag.getTag().func_74757_a(resolvedKey, data.resolved);
        this.itemTag.checkEmpty();
        return this;
    }

    public boolean getResolved() {
        return this.itemTag.getTag().func_74767_n(resolvedKey);
    }

    public InfinityBookTags setResolved(boolean resolved) {
        if (resolved) {
            this.itemTag.getTag().func_74757_a(resolvedKey, resolved);
        } else {
            this.itemTag.getTag().func_82580_o(resolvedKey);
        }
        this.itemTag.checkEmpty();
        return this;
    }

    public InfinityBookTags toggleResolved() {
        return this.setResolved(!this.getResolved());
    }

    public static class SignedData {
        private final NBTTagList pages;
        private final int generation;
        private final String author;
        private final String title;
        private final boolean resolved;

        public SignedData(NBTTagList pages, int generation, String author, String title, boolean resolved) {
            this.pages = pages;
            this.generation = generation;
            this.author = author;
            this.title = title;
            this.resolved = resolved;
        }

        protected SignedData(NBTTagCompound itemTag) {
            this.pages = itemTag.func_150295_c(InfinityBookTags.pagesKey, 8);
            this.generation = itemTag.func_74762_e(InfinityBookTags.generationKey);
            this.author = itemTag.func_74779_i(InfinityBookTags.authorKey);
            this.title = itemTag.func_74779_i(InfinityBookTags.titleKey);
            this.resolved = itemTag.func_74767_n(InfinityBookTags.resolvedKey);
        }
    }
}

