/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.tab;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import ruukas.infinityeditor.InfinityEditor;
import ruukas.infinityeditor.data.InfinityConfig;
import ruukas.infinityeditor.data.thevoid.VoidController;
import ruukas.infinityeditor.tab.InfinityTabBanners;
import ruukas.infinityeditor.tab.InfinityTabFireworks;
import ruukas.infinityeditor.tab.InfinityTabRealm;
import ruukas.infinityeditor.tab.InfinityTabSkulls;
import ruukas.infinityeditor.tab.InfinityTabThief;

public abstract class InfinityTab
extends CreativeTabs {
    public InfinityTab(String label) {
        super(label);
    }

    public InfinityTab(int index, String label) {
        super(index, label);
    }

    public static void initTabs() {
        int foundId;
        int tabs = 7 - (InfinityConfig.getIsVoidEnabled() ? 0 : 1) - (InfinityConfig.getIsUnavailableTabEnabled() ? 0 : 1) - (InfinityConfig.getIsBannerTabEnabled() ? 0 : 1) - (InfinityConfig.getIsHeadTabEnabled() ? 0 : 1) - (InfinityConfig.getIsThiefTabEnabled() ? 0 : 1) - (InfinityConfig.getIsFireworkTabEnabled() ? 0 : 1);
        int id = InfinityTab.getNextID();
        boolean successRealm = false;
        for (int i = foundId = id; i < foundId + tabs; ++i) {
            if ((i - 16) % 5 != 0) continue;
            foundId = i;
            successRealm = true;
            break;
        }
        InfinityEditor.REALM = new InfinityTabRealm(successRealm ? foundId : id++, "realm", successRealm);
        if (InfinityConfig.getIsUnavailableTabEnabled()) {
            InfinityEditor.UNAVAILABLE = new InfinityTab(id >= foundId ? 1 + id++ : id++, "unavailable"){

                public ItemStack func_78016_d() {
                    return new ItemStack(Blocks.field_180401_cv);
                }

                public void func_78018_a(NonNullList<ItemStack> stackList) {
                    super.func_78018_a(stackList);
                    stackList.add((Object)new ItemStack(Items.field_151063_bx));
                    stackList.add((Object)new ItemStack((Item)Items.field_151068_bn));
                    stackList.add((Object)new ItemStack((Item)Items.field_185155_bH));
                    stackList.add((Object)new ItemStack((Item)Items.field_185156_bI));
                    stackList.add((Object)new ItemStack(Items.field_185167_i));
                    stackList.add((Object)new ItemStack(Items.field_151134_bR));
                }
            };
        }
        if (InfinityConfig.getIsBannerTabEnabled()) {
            InfinityEditor.BANNERS = new InfinityTabBanners(id >= foundId ? 1 + id++ : id++);
        }
        if (InfinityConfig.getIsHeadTabEnabled()) {
            InfinityEditor.SKULLS = new InfinityTabSkulls(id >= foundId ? 1 + id++ : id++);
        }
        if (InfinityConfig.getIsThiefTabEnabled()) {
            InfinityEditor.THIEF = new InfinityTabThief(id >= foundId ? 1 + id++ : id++);
        }
        if (InfinityConfig.getIsFireworkTabEnabled()) {
            InfinityEditor.FIREWORKS = new InfinityTabFireworks(id >= foundId ? 1 + id++ : id++);
        }
        if (InfinityConfig.getIsVoidEnabled()) {
            InfinityEditor.VOID = new InfinityTab(id >= foundId ? 1 + id++ : id++, "void"){

                public ItemStack func_78016_d() {
                    return new ItemStack((Block)Blocks.field_150399_cn, 1, 15);
                }

                public void func_78018_a(NonNullList<ItemStack> stackList) {
                    super.func_78018_a(stackList);
                    VoidController.loadVoidToList(stackList);
                }

                public boolean hasSearchBar() {
                    return true;
                }
            }.func_78025_a("item_search.png");
        }
    }
}

