/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.util;

import java.util.Iterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ruukas.infinityeditor.InfinityEditor;
import ruukas.infinityeditor.util.GiveHelper;

public class InventoryUtils {
    public static int countItem(InventoryPlayer inventory, Item item) {
        int count = 0;
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack.func_77973_b() != item) continue;
            ++count;
        }
        return count;
    }

    public static int countItem(InventoryPlayer inventory, Item item, int meta) {
        int count = 0;
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack.func_77973_b() != item || stack.func_77960_j() != meta) continue;
            ++count;
        }
        return count;
    }

    public static int getEmptySlots(InventoryPlayer inventory) {
        int count = 0;
        for (ItemStack stack : inventory.field_70462_a) {
            if (!stack.func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public static int getEmptySlot(InventoryPlayer inventory) {
        ItemStack stack;
        int count = 0;
        Iterator iterator = inventory.field_70462_a.iterator();
        while (iterator.hasNext() && !(stack = (ItemStack)iterator.next()).func_190926_b()) {
            ++count;
        }
        if (count <= 8) {
            count += 36;
        } else if (36 <= count && count <= 39) {
            count = 8 - count % 4;
        } else if (count == 40) {
            count = 45;
        }
        return count;
    }

    public static void onPickBlock(RayTraceResult target, EntityPlayerSP player, World world) {
        IBlockState state;
        TileEntity te = null;
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            state = world.func_180495_p(target.func_178782_a());
            if (state.func_177230_c().isAir(state, (IBlockAccess)world, target.func_178782_a())) {
                return;
            }
            if (state.func_177230_c().hasTileEntity(state)) {
                te = world.func_175625_s(target.func_178782_a());
            }
        } else {
            return;
        }
        ItemStack result = state.func_177230_c().getPickBlock(state, target, world, target.func_178782_a(), (EntityPlayer)player);
        if (result.func_190926_b()) {
            return;
        }
        if (te != null) {
            Minecraft.func_71410_x().func_184119_a(result, te);
        }
        String s = GiveHelper.getStringFromItemStack(result);
        GuiScreen.func_146275_d((String)s);
        if (GuiScreen.func_146271_m()) {
            InfinityEditor.realmController.addItemStack(player, result);
        }
    }
}

