/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.util;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;

public class QualityHelper {
    public static int getArmorQualityFromMaterial(ItemArmor.ArmorMaterial material) {
        int quality = 0;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            quality += material.func_78044_b(slot);
        }
        return quality;
    }

    public static int compareBoolean(boolean bool1, boolean bool2) {
        return bool1 ? (bool2 ? 0 : -1) : (bool2 ? 1 : 0);
    }

    public static boolean getBlockInstanceof(Item item, Class<?> blockclass) {
        if (item instanceof ItemBlock) {
            return blockclass.isInstance(Block.func_149634_a((Item)item));
        }
        return false;
    }

    public static boolean getIsItemEqualToBlock(Item item, Block block) {
        if (item instanceof ItemBlock) {
            return Block.func_149634_a((Item)item).equals(block);
        }
        return false;
    }

    public static String getItemType(Item item) {
        return item instanceof ItemBlock ? ((ItemBlock)item).func_179223_d().getClass().getSimpleName() : item.getClass().getSimpleName();
    }

    public static double getFoodQuality(Item item) {
        if (item == Items.field_151105_aU) {
            return 16.4;
        }
        if (item instanceof ItemFood) {
            ItemStack foodStack = new ItemStack(item);
            ItemFood food = (ItemFood)item;
            return (float)(food.func_150905_g(foodStack) + food.func_150905_g(foodStack)) * food.func_150906_h(foodStack) * 2.0f;
        }
        return 0.0;
    }

    public static Item getMostDurablePickaxe() {
        Item bestPickaxe = null;
        for (Item item : Item.field_150901_e) {
            if (item == null || !(item instanceof ItemPickaxe)) continue;
            if (bestPickaxe == null) {
                bestPickaxe = item;
                continue;
            }
            if (new ItemStack(item).func_77958_k() <= new ItemStack(bestPickaxe).func_77958_k()) continue;
            bestPickaxe = item;
        }
        return bestPickaxe;
    }

    public static Item getBestFood() {
        Item bestFood = null;
        for (Item item : Item.field_150901_e) {
            if (item == null || !(item instanceof ItemFood)) continue;
            if (bestFood == null) {
                bestFood = item;
                continue;
            }
            if (!(QualityHelper.getFoodQuality(item) > QualityHelper.getFoodQuality(bestFood))) continue;
            bestFood = item;
        }
        return bestFood;
    }

    public static Item getStrongestSword() {
        Item bestSword = null;
        for (Item item : Item.field_150901_e) {
            if (item == null || !(item instanceof ItemSword)) continue;
            if (bestSword == null) {
                bestSword = item;
                continue;
            }
            if (!(((ItemSword)item).func_150931_i() > ((ItemSword)bestSword).func_150931_i())) continue;
            bestSword = item;
        }
        return bestSword;
    }

    public static TextFormatting getTextFormatFromDye(EnumDyeColor dye) {
        switch (dye) {
            case BLACK: {
                return TextFormatting.DARK_GRAY;
            }
            case BLUE: {
                return TextFormatting.DARK_BLUE;
            }
            case BROWN: {
                return TextFormatting.GOLD;
            }
            case CYAN: {
                return TextFormatting.DARK_AQUA;
            }
            case GRAY: {
                return TextFormatting.DARK_GRAY;
            }
            case GREEN: {
                return TextFormatting.DARK_GREEN;
            }
            case LIGHT_BLUE: {
                return TextFormatting.BLUE;
            }
            case LIME: {
                return TextFormatting.GREEN;
            }
            case MAGENTA: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case ORANGE: {
                return TextFormatting.GOLD;
            }
            case PINK: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case PURPLE: {
                return TextFormatting.DARK_PURPLE;
            }
            case RED: {
                return TextFormatting.DARK_RED;
            }
            case SILVER: {
                return TextFormatting.GRAY;
            }
            case WHITE: {
                return TextFormatting.WHITE;
            }
            case YELLOW: {
                return TextFormatting.YELLOW;
            }
        }
        return TextFormatting.RESET;
    }

    public static boolean hasItem(Item item) {
        InventoryPlayer inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
        NonNullList allInventories = NonNullList.func_191196_a();
        allInventories.add((Object)inventory.field_70462_a);
        allInventories.add((Object)inventory.field_70460_b);
        allInventories.add((Object)inventory.field_184439_c);
        for (NonNullList aitemstack : allInventories) {
            for (ItemStack itemstack : aitemstack) {
                if (itemstack == null || itemstack.func_77973_b() == null || !itemstack.func_77973_b().equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasItemInMainInventory(Item item) {
        return QualityHelper.getFirstStackOfItemInMainInventory(item) != null;
    }

    public static ItemStack getFirstStackOfItemInMainInventory(Item item) {
        for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() == null || !stack.func_77973_b().equals(item)) continue;
            return stack;
        }
        return null;
    }

    public static boolean isItemInCreativeTab(Item item, CreativeTabs targetTab) {
        for (CreativeTabs tab : item.getCreativeTabs()) {
            if (tab != targetTab) continue;
            return true;
        }
        CreativeTabs creativetabs = item.func_77640_w();
        return creativetabs != null && (targetTab == CreativeTabs.field_78027_g || targetTab == creativetabs);
    }
}

