/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.client.lock;

import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.BlockLockPosition;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.pollen.api.event.events.network.ClientNetworkEvents;
import gg.moonflower.pollen.api.event.events.world.ChunkEvents;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public final class ClientLockManager
implements LockManager {
    private static final Map<class_5321<class_1937>, ClientLockManager> INSTANCES = new HashMap<class_5321<class_1937>, ClientLockManager>();
    private final Map<LockPosition, AbstractLock> locks = new HashMap<LockPosition, AbstractLock>();
    private final class_638 level;

    private ClientLockManager(class_638 level) {
        this.level = level;
    }

    public static ClientLockManager getOrCreate(class_638 level) {
        return INSTANCES.computeIfAbsent((class_5321<class_1937>)level.method_27983(), levelResourceKey -> new ClientLockManager(level));
    }

    @Override
    @Nullable
    public AbstractLock getLock(LockPosition pos) {
        AbstractLock lock = this.locks.get(pos);
        if (lock != null) {
            return lock;
        }
        if (pos instanceof BlockLockPosition) {
            class_2338 offsetPos = LockManager.getLockPosition((class_1937)this.level, pos.blockPosition());
            if (!pos.blockPosition().equals((Object)offsetPos)) {
                return this.locks.get(LockPosition.of(offsetPos));
            }
        }
        return null;
    }

    @Override
    public void addLock(AbstractLock data) {
        this.locks.put(data.getPos(), data);
    }

    private void removeLock(LockPosition pos) {
        this.locks.remove(pos);
    }

    @Override
    public void removeLock(class_2338 pos, class_2338 clickPos, boolean drop) {
        this.removeLock(LockPosition.of(pos));
    }

    @Override
    public void removeLock(class_1297 entity, boolean drop) {
        this.removeLock(LockPosition.of(entity));
    }

    public void clearLocks(class_1923 chunk) {
        this.locks.values().removeIf(lock -> lock.getPos() instanceof BlockLockPosition && lock.getPos().blockPosition().method_10263() >> 4 == chunk.field_9181 && lock.getPos().blockPosition().method_10260() >> 4 == chunk.field_9180);
    }

    static {
        ClientNetworkEvents.LOGOUT.register((controller, player, connection) -> INSTANCES.clear());
        ChunkEvents.UNLOAD.register((level, chunk) -> {
            if (level instanceof class_1937) {
                ClientLockManager manager = INSTANCES.get(((class_1937)level).method_27983());
                if (manager == null) {
                    return;
                }
                manager.clearLocks(chunk.method_12004());
            }
        });
    }
}

