/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lock;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import gg.moonflower.locksmith.api.lock.position.BlockLockPosition;
import gg.moonflower.locksmith.api.lock.position.EntityLockPosition;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LockPositionCodec
implements Codec<Type> {
    private static final LockPositionCodec CODEC = new LockPositionCodec();

    private LockPositionCodec() {
    }

    public static Codec<LockPosition> create() {
        return CODEC.dispatch(Type::getType, Type::codec);
    }

    public <U> DataResult<Pair<Type, U>> decode(DynamicOps<U> ops, U input) {
        return ops.compressMaps() ? ops.getNumberValue(input).flatMap(number -> {
            int id = number.intValue();
            Type object = id < 0 || id >= Type.values().length ? null : Type.values()[id];
            return object == null ? DataResult.error((String)("Unknown lock position id: " + number)) : DataResult.success((Object)((Object)object), (Lifecycle)Lifecycle.stable());
        }).map(pos -> Pair.of((Object)pos, (Object)ops.empty())) : Codec.STRING.decode(ops, input).flatMap(pair -> {
            Type object = Type.byName((String)pair.getFirst());
            return object == null ? DataResult.error((String)("Unknown lock position key: " + (String)pair.getFirst())) : DataResult.success((Object)Pair.of((Object)((Object)object), (Object)pair.getSecond()), (Lifecycle)Lifecycle.stable());
        });
    }

    public <U> DataResult<U> encode(Type input, DynamicOps<U> ops, U prefix) {
        return ops.compressMaps() ? ops.mergeToPrimitive(prefix, ops.createInt(input.ordinal())).setLifecycle(Lifecycle.stable()) : ops.mergeToPrimitive(prefix, ops.createString(input.name().toLowerCase(Locale.ROOT))).setLifecycle(Lifecycle.stable());
    }

    public static enum Type {
        BLOCK(BlockLockPosition.CODEC),
        ENTITY(EntityLockPosition.CODEC);

        private final Codec<? extends LockPosition> codec;

        private Type(Codec<? extends LockPosition> codec) {
            this.codec = codec;
        }

        public Codec<? extends LockPosition> codec() {
            return this.codec;
        }

        @Nullable
        public static Type getType(LockPosition lockPosition) {
            if (lockPosition instanceof EntityLockPosition) {
                return ENTITY;
            }
            if (lockPosition instanceof BlockLockPosition) {
                return BLOCK;
            }
            return null;
        }

        @Nullable
        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().toLowerCase(Locale.ROOT).equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

