/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lock.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.locksmith.api.key.Key;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockType;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.menu.LockpickingMenu;
import gg.moonflower.locksmith.core.Locksmith;
import gg.moonflower.locksmith.core.registry.LocksmithItems;
import gg.moonflower.locksmith.core.registry.LocksmithLocks;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4844;

public class KeyLock
extends AbstractLock {
    public static final Codec<KeyLock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("id").forGetter(AbstractLock::getId), (App)LockPosition.CODEC.fieldOf("pos").forGetter(AbstractLock::getPos), (App)class_1799.field_24671.fieldOf("stack").forGetter(AbstractLock::getStack)).apply((Applicative)instance, KeyLock::new));
    private static final class_2561 LOCK_PICKING = new class_2588("container.locksmith.lock_picking");

    public KeyLock(LockType type, UUID id, LockPosition pos, class_1799 stack) {
        super(type, id, pos, stack);
    }

    public KeyLock(UUID id, LockPosition pos, class_1799 stack) {
        this(LocksmithLocks.KEY.get(), id, pos, stack);
    }

    @Override
    public boolean canRemove(class_1657 player, class_1937 level, class_1799 stack) {
        return player.method_21823() && (stack.method_7909() == LocksmithItems.KEY.get() || stack.method_7909() == LocksmithItems.KEYRING.get()) && ((Key)stack.method_7909()).matchesLock(this.getId(), stack);
    }

    @Override
    public boolean canUnlock(class_1657 player, class_1937 level, class_1799 stack) {
        return player.method_7337() || (stack.method_7909() == LocksmithItems.KEY.get() || stack.method_7909() == LocksmithItems.KEYRING.get()) && ((Key)stack.method_7909()).matchesLock(this.getId(), stack);
    }

    @Override
    public boolean pick(class_1657 player, class_1937 level, final LockPosition pos, final class_1799 pickStack, final class_1268 hand) {
        if (pickStack.method_7909() != LocksmithItems.LOCKPICK.get()) {
            return false;
        }
        if (!level.method_8608()) {
            player.method_17355(new class_3908(){

                public class_2561 method_5476() {
                    return LOCK_PICKING;
                }

                public class_1703 createMenu(int containerId, class_1661 inventory, class_1657 player) {
                    return new LockpickingMenu(containerId, LockPickingContext.server(KeyLock.this.getPos(), pos.blockPosition(), (class_3222)player, pickStack, hand));
                }
            });
        }
        return true;
    }

    @Override
    public boolean onRightClick(class_1657 player, class_1937 level, class_1799 stack, class_3965 hitResult) {
        if (this.canUnlock(player, level, stack)) {
            player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            return true;
        }
        return false;
    }

    @Override
    public boolean onLeftClick(class_1657 player, class_1937 level, class_1268 hand, class_2338 pos, class_2350 direction) {
        return (Boolean)Locksmith.CONFIG.allowLocksToBeBroken.get();
    }

    @Override
    public boolean onRightClick(class_1657 player, class_1937 level, class_1799 stack, class_1297 entity) {
        if (this.canUnlock(player, level, stack)) {
            player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            return true;
        }
        return false;
    }

    @Override
    public boolean onLeftClick(class_1657 player, class_1937 level, class_1268 hand, class_1297 entity) {
        return false;
    }
}

