/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lockpicking;

import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.network.LocksmithMessages;
import gg.moonflower.locksmith.common.network.play.ClientboundLockPickingPacket;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import gg.moonflower.locksmith.core.registry.LocksmithStats;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class ServerPickingContext
extends LockPickingContext {
    public static final int FAIL_WAIT_TIME = 10;
    public static final int FAIL_THRESHOLD = 10;
    protected final class_3222 player;
    protected final class_1799 pickStack;
    protected final class_1268 pickHand;
    protected final Game game;
    protected int lastSetTime;
    protected LockPickingContext.GameState state;
    protected int stop;

    protected ServerPickingContext(class_3222 player, class_1799 pickStack, class_1268 pickHand) {
        this.player = player;
        this.pickStack = pickStack;
        this.pickHand = pickHand;
        Random random = player.field_6002.method_8409();
        this.game = new Game(2, random);
        this.state = LockPickingContext.GameState.RUNNING;
        this.stop = 0;
        this.setPickDamage(pickStack.method_7919());
    }

    protected abstract void playSound(class_3414 var1);

    protected abstract void removeLock();

    @Override
    public void pick(int pin) {
        if (this.getPinState(pin)) {
            LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(pin, true));
            return;
        }
        if (this.game.shouldDrop(pin)) {
            this.playSound(LocksmithSounds.LOCK_PICKING_SET.get());
            this.setPinState(pin, true);
            this.game.next(this);
            if (this.areAllPinsSet()) {
                this.stop(true);
            }
        } else {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.game.reset();
        this.playSound(LocksmithSounds.LOCK_PICKING_PINS_DROP.get());
        this.pickStack.method_7956(1, (class_1309)this.player, contextPlayer -> {
            this.state = LockPickingContext.GameState.FAIL;
            this.stop = this.player.field_6012;
            this.playSound(LocksmithSounds.LOCK_PICKING_FAIL.get());
            LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.FAIL));
            contextPlayer.method_20236(this.pickHand);
        });
        this.setPickDamage(this.pickStack.method_7960() ? 2 : this.pickStack.method_7919());
        this.player.field_7498.method_7623();
        super.reset();
        LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.RESET));
    }

    @Override
    public void stop(boolean success) {
        this.state = success ? LockPickingContext.GameState.SUCCESS : LockPickingContext.GameState.FAIL;
        this.stop = this.player.field_6012;
        this.playSound(success ? LocksmithSounds.LOCK_PICKING_SUCCESS.get() : LocksmithSounds.LOCK_PICKING_FAIL.get());
        if (success) {
            LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.SUCCESS));
            this.player.method_7281(LocksmithStats.PICK_LOCK);
            this.removeLock();
            return;
        }
        this.pickStack.method_7956(1, (class_1309)this.player, contextPlayer -> contextPlayer.method_20236(this.pickHand));
        this.setPickDamage(this.pickStack.method_7960() ? 2 : this.pickStack.method_7919());
        LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.FAIL));
    }

    @Override
    public LockPickingContext.GameState getState() {
        return this.state;
    }

    @Override
    public void setPinState(int pin, boolean set) {
        if (pin < 0 || pin >= 5) {
            return;
        }
        super.setPinState(pin, set);
        if (this.player.field_6012 - this.lastSetTime < 10) {
            this.playSound(LocksmithSounds.LOCK_PICKING_OVERSET.get());
            this.stop(false);
            return;
        }
        this.lastSetTime = this.player.field_6012;
        LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(pin, set));
    }

    @Override
    public boolean stillValid(class_1657 player) {
        return this.player == player && (this.state == LockPickingContext.GameState.RUNNING || this.player.field_6012 - this.stop < 10);
    }

    public static class Game {
        private final int[] droppingPins;
        private int droppingIndex;

        private Game(int complexity, Random random) {
            int size = class_3532.method_15340((int)complexity, (int)0, (int)4);
            ArrayList<Integer> pins = new ArrayList<Integer>(size);
            while (pins.size() < size) {
                pins.add(random.nextInt(5));
            }
            this.droppingPins = pins.stream().mapToInt(Integer::intValue).toArray();
            this.droppingIndex = -1;
        }

        private boolean isNonDropping(int pin) {
            return IntStream.of(this.droppingPins).noneMatch(dropping -> dropping == pin);
        }

        public void reset() {
            this.droppingIndex = -1;
        }

        public void next(LockPickingContext context) {
            if (this.droppingIndex >= 0) {
                ++this.droppingIndex;
            } else {
                for (int i = 0; i < 5; ++i) {
                    if (!this.isNonDropping(i) || context.getPinState(i)) continue;
                    return;
                }
                this.droppingIndex = 0;
            }
        }

        public boolean shouldDrop(int pin) {
            return this.droppingIndex == -1 ? this.isNonDropping(pin) : this.droppingPins[this.droppingIndex] == pin;
        }
    }
}

