/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.network.play.handler;

import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.BlockLockPosition;
import gg.moonflower.locksmith.api.lock.position.EntityLockPosition;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.client.lock.ClientLockManager;
import gg.moonflower.locksmith.client.screen.LockPickingScreen;
import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.menu.LockpickingMenu;
import gg.moonflower.locksmith.common.network.play.ClientboundAddLocksPacket;
import gg.moonflower.locksmith.common.network.play.ClientboundDeleteLocksPacket;
import gg.moonflower.locksmith.common.network.play.ClientboundLockPickingPacket;
import gg.moonflower.locksmith.common.network.play.handler.LocksmithClientPlayPacketHandler;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;

public class LocksmithClientPlayPacketHandlerImpl
implements LocksmithClientPlayPacketHandler {
    private class_1297 getLockEntity(class_638 level, EntityLockPosition pos) {
        UUID id = pos.getEntityId();
        for (class_1297 e : level.method_18112()) {
            if (!e.method_5667().equals(id)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void handleAddLocks(ClientboundAddLocksPacket msg, PollinatedPacketContext ctx) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        LockManager manager = LockManager.get((class_1937)level);
        ctx.enqueueWork(() -> {
            if (msg.isReplace()) {
                msg.getLocks().stream().filter(lock -> lock.getPos() instanceof BlockLockPosition).map(lock -> new class_1923(lock.getPos().blockPosition())).distinct().forEach(chunk -> ((ClientLockManager)manager).clearLocks((class_1923)chunk));
            }
            for (AbstractLock lock2 : msg.getLocks()) {
                if (lock2.getPos() instanceof EntityLockPosition) {
                    EntityLockPosition entityLockPos = (EntityLockPosition)lock2.getPos();
                    entityLockPos.setEntity(() -> this.getLockEntity(level, entityLockPos));
                }
                manager.addLock(lock2);
            }
        });
    }

    @Override
    public void handleDeleteLock(ClientboundDeleteLocksPacket msg, PollinatedPacketContext ctx) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        for (LockPosition pos : msg.getPositions()) {
            class_1297 e;
            if (pos instanceof BlockLockPosition) {
                ctx.enqueueWork(() -> LockManager.get((class_1937)level).removeLock(pos.blockPosition()));
                continue;
            }
            if (!(pos instanceof EntityLockPosition) || (e = this.getLockEntity(level, (EntityLockPosition)pos)) == null) continue;
            ctx.enqueueWork(() -> LockManager.get((class_1937)level).removeLock(e));
        }
    }

    @Override
    public void handleLockPicking(ClientboundLockPickingPacket msg, PollinatedPacketContext ctx) {
        class_437 screen = class_310.method_1551().field_1755;
        if (!(screen instanceof LockPickingScreen)) {
            return;
        }
        LockPickingContext context = ((LockpickingMenu)((LockPickingScreen)screen).method_17577()).getContext();
        ctx.enqueueWork(() -> {
            switch (msg.getType()) {
                case SET: {
                    context.setPinState(msg.getPin(), msg.isSet());
                    ((LockPickingScreen)screen).lowerPick();
                    break;
                }
                case RESET: {
                    context.reset();
                    ((LockPickingScreen)screen).lowerPick();
                    break;
                }
                case SUCCESS: {
                    context.stop(true);
                    break;
                }
                case FAIL: {
                    context.stop(false);
                }
            }
        });
    }
}

