/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.item;

import gg.moonflower.locksmith.api.key.Key;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.item.KeyringItem;
import gg.moonflower.locksmith.core.Locksmith;
import gg.moonflower.locksmith.core.registry.LocksmithItems;
import gg.moonflower.locksmith.core.registry.LocksmithTags;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.Nullable;

public class KeyItem
extends class_1792
implements Key {
    private static final class_2561 ORIGINAL = new class_2588("item.locksmith.key.original").method_27692(class_124.field_1080);
    private static final class_2561 COPY = new class_2588("item.locksmith.key.copy").method_27692(class_124.field_1080);

    public KeyItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        AbstractLock abstractLock = LockManager.get(level).getLock(LockPosition.of(pos));
        if (player == null || abstractLock == null) {
            return class_1269.field_5811;
        }
        if (abstractLock.canRemove(player, level, context.method_8041())) {
            if (level.method_8608()) {
                return class_1269.field_5812;
            }
            LockManager.get(level).removeLock(abstractLock.getPos().blockPosition(), pos, true);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public boolean method_31565(class_1799 key, class_1735 slot, class_5536 clickAction, class_1657 player) {
        if (((Boolean)Locksmith.CONFIG.useKeyringMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != class_5536.field_27014) {
            return false;
        }
        return KeyItem.addKeyring(key, slot.method_7677(), slot, player);
    }

    public boolean method_31566(class_1799 key, class_1799 clickItem, class_1735 slot, class_5536 clickAction, class_1657 player, class_5630 slotAccess) {
        if (((Boolean)Locksmith.CONFIG.useKeyringMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction == class_5536.field_27014 && slot.method_32754(player)) {
            return KeyItem.addKeyring(key, clickItem, slot, player);
        }
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        if (level != null) {
            tooltipComponents.add(KeyItem.isOriginal(stack) ? ORIGINAL : COPY);
        }
        if (isAdvanced.method_8035()) {
            UUID id = KeyItem.getLockId(stack);
            if (id == null || class_156.field_25140.equals(id)) {
                return;
            }
            tooltipComponents.add((class_2561)new class_2585("Lock Id: " + id).method_27692(class_124.field_1063));
        }
    }

    private static boolean addKeyring(class_1799 key, class_1799 clickItem, class_1735 slot, class_1657 player) {
        if (clickItem.method_7960()) {
            return false;
        }
        if (!clickItem.method_31574(LocksmithItems.KEY.get())) {
            return false;
        }
        player.method_5783(class_3417.field_34376, 0.8f, 0.8f + player.method_37908().method_8409().nextFloat() * 0.4f);
        class_1799 keyring = new class_1799((class_1935)LocksmithItems.KEYRING.get());
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            if (((class_1799)player.method_31548().field_7547.get(i)).method_7960() || slot.method_7677() != player.method_31548().field_7547.get(i)) continue;
            KeyringItem.setKeys(keyring, Arrays.asList(key.method_7971(1), slot.method_32753(clickItem.method_7947(), 1, player)));
            player.method_31548().method_5447(i, keyring);
            return true;
        }
        KeyringItem.setKeys(keyring, Arrays.asList(key.method_7971(1), slot.method_32753(clickItem.method_7947(), 1, player)));
        player.method_31548().method_7398(keyring);
        return true;
    }

    @Override
    public boolean matchesLock(UUID id, class_1799 stack) {
        return id.equals(KeyItem.getLockId(stack));
    }

    public static boolean canHaveLock(class_1799 stack) {
        return stack.method_31573(LocksmithTags.LOCKING);
    }

    public static boolean isKey(class_1799 stack) {
        return !stack.method_31573(LocksmithTags.BLANK_KEY) && stack.method_7909() instanceof Key;
    }

    public static boolean isBlankKey(class_1799 stack) {
        return stack.method_31573(LocksmithTags.BLANK_KEY);
    }

    public static boolean hasLockId(class_1799 stack) {
        if (stack.method_7969() == null || !KeyItem.canHaveLock(stack)) {
            return false;
        }
        class_2487 tag = stack.method_7969();
        return tag.method_25928("Lock");
    }

    @Nullable
    public static UUID getLockId(class_1799 stack) {
        if (stack.method_7969() == null || !KeyItem.canHaveLock(stack)) {
            return null;
        }
        class_2487 tag = stack.method_7969();
        return tag.method_25928("Lock") ? tag.method_25926("Lock") : null;
    }

    public static void setLockId(class_1799 stack, @Nullable UUID id) {
        if (KeyItem.canHaveLock(stack)) {
            if (stack.method_7969() == null && id == null) {
                return;
            }
            if (id == null) {
                stack.method_7969().method_10551("Lock");
                if (stack.method_7969().method_33133()) {
                    stack.method_7980(null);
                }
                return;
            }
            stack.method_7948().method_25927("Lock", id);
        }
    }

    public static boolean isOriginal(class_1799 stack) {
        return KeyItem.isKey(stack) && KeyItem.hasLockId(stack) && stack.method_7948().method_10577("Original");
    }

    public static void setOriginal(class_1799 stack, boolean original) {
        if (KeyItem.isKey(stack) && KeyItem.hasLockId(stack)) {
            stack.method_7948().method_10556("Original", original);
        }
    }
}

