/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.item;

import gg.moonflower.locksmith.api.key.Key;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.menu.KeyringMenu;
import gg.moonflower.locksmith.common.tooltip.KeyringTooltip;
import gg.moonflower.locksmith.core.Locksmith;
import gg.moonflower.locksmith.core.registry.LocksmithItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3908;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;

public class KeyringItem
extends class_1792
implements Key {
    public static final int MAX_KEYS = 4;

    public KeyringItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public boolean matchesLock(UUID id, class_1799 stack) {
        for (class_1799 key : KeyringItem.getKeys(stack)) {
            if (!id.equals(KeyItem.getLockId(key))) continue;
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        final class_1799 stack = player.method_5998(hand);
        if (!player.method_21823()) {
            return class_1271.method_22430((Object)stack);
        }
        if (((Boolean)Locksmith.CONFIG.useKeyringMenu.get()).booleanValue()) {
            final int index = player.method_31548().method_7395(stack);
            if (index == -1) {
                return class_1271.method_22430((Object)stack);
            }
            if (!level.method_8608()) {
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
                player.method_17355(new class_3908(){

                    public class_2561 method_5476() {
                        return stack.method_7964();
                    }

                    public class_1703 createMenu(int containerId, class_1661 inventory, class_1657 player) {
                        return new KeyringMenu(containerId, inventory, index);
                    }
                });
            }
            return class_1271.method_29237((Object)stack, (boolean)level.method_8608());
        }
        if (KeyringItem.dropContents(stack, player)) {
            this.playDropContentsSound((class_1297)player);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)class_1799.field_8037, (boolean)level.method_8608());
        }
        return class_1271.method_22431((Object)stack);
    }

    public boolean method_31565(class_1799 keyRing, class_1735 slot, class_5536 clickAction, class_1657 player) {
        if (((Boolean)Locksmith.CONFIG.useKeyringMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != class_5536.field_27014) {
            return false;
        }
        class_1799 clickItem = slot.method_7677();
        if (clickItem.method_7960()) {
            this.playRemoveOneSound((class_1297)player);
            KeyringItem.removeOne(player, keyRing).ifPresent(key -> KeyringItem.add(keyRing, slot.method_32756(key)));
        } else if (KeyringItem.canAdd(keyRing, clickItem)) {
            this.playInsertSound((class_1297)player);
            KeyringItem.add(keyRing, slot.method_32753(clickItem.method_7947(), 1, player));
        }
        return true;
    }

    public boolean method_31566(class_1799 keyRing, class_1799 clickItem, class_1735 slot, class_5536 clickAction, class_1657 player, class_5630 slotAccess) {
        if (((Boolean)Locksmith.CONFIG.useKeyringMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction == class_5536.field_27014 && slot.method_32754(player)) {
            if (clickItem.method_7960()) {
                KeyringItem.removeOne(player, keyRing).ifPresent(removedKey -> {
                    this.playRemoveOneSound((class_1297)player);
                    slotAccess.method_32332(removedKey);
                });
            } else if (KeyringItem.canAdd(keyRing, clickItem)) {
                this.playInsertSound((class_1297)player);
                KeyringItem.add(keyRing, clickItem);
            }
            return true;
        }
        return false;
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        AbstractLock lock = LockManager.get(level).getLock(LockPosition.of(pos));
        if (player == null || lock == null) {
            return class_1269.field_5811;
        }
        for (class_1799 key : KeyringItem.getKeys(context.method_8041())) {
            if (!lock.canRemove(player, level, key)) continue;
            if (level.method_8608()) {
                return class_1269.field_5812;
            }
            LockManager.get(level).removeLock(lock.getPos().blockPosition(), pos, true);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public Optional<class_5632> method_32346(class_1799 itemStack) {
        return Optional.of(new KeyringTooltip(KeyringItem.getKeys(itemStack)));
    }

    public void method_33261(class_1542 itemEntity) {
        class_5328.method_33263((class_1542)itemEntity, KeyringItem.getKeys(itemEntity.method_6983()).stream());
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().nextFloat() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().nextFloat() * 0.4f);
    }

    public static List<class_1799> getKeys(class_1799 stack) {
        if (!stack.method_31574(LocksmithItems.KEYRING.get())) {
            return Collections.emptyList();
        }
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10573("Keys", 9)) {
            return Collections.emptyList();
        }
        class_2499 keysNbt = nbt.method_10554("Keys", 10);
        if (keysNbt.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<class_1799> list = new ArrayList<class_1799>(keysNbt.size());
        for (int i = 0; i < Math.min(4, keysNbt.size()); ++i) {
            class_1799 key = class_1799.method_7915((class_2487)keysNbt.method_10602(i));
            if (key.method_7960()) continue;
            list.add(key);
        }
        return list;
    }

    public static void setKeys(class_1799 stack, Collection<class_1799> keys) {
        if (!stack.method_31574(LocksmithItems.KEYRING.get()) || keys.isEmpty()) {
            return;
        }
        class_2487 nbt = stack.method_7948();
        class_2499 keysNbt = new class_2499();
        int i = 0;
        for (class_1799 key : keys) {
            if (key.method_7960()) continue;
            if (i >= 4) break;
            keysNbt.add((Object)key.method_7953(new class_2487()));
            ++i;
        }
        nbt.method_10566("Keys", (class_2520)keysNbt);
    }

    private static Optional<class_1799> removeOne(class_1657 player, class_1799 keyRing) {
        class_2487 tag = keyRing.method_7948();
        if (!tag.method_10573("Keys", 9)) {
            return Optional.empty();
        }
        class_2499 keysNbt = tag.method_10554("Keys", 10);
        if (keysNbt.isEmpty()) {
            return Optional.empty();
        }
        class_2487 keyNbt = keysNbt.method_10602(0);
        class_1799 keyStack = class_1799.method_7915((class_2487)keyNbt);
        keysNbt.method_10536(0);
        if (keysNbt.size() == 1) {
            class_1799 last = class_1799.method_7915((class_2487)keysNbt.method_10602(0));
            class_1799 carried = player.field_7498.method_34255();
            if (!carried.method_7960() && carried == keyRing) {
                keyRing.method_7939(0);
                player.field_7498.method_34254(last);
                return Optional.of(keyStack);
            }
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < inventory.field_7547.size(); ++i) {
                if (((class_1799)inventory.field_7547.get(i)).method_7960() || keyRing != inventory.field_7547.get(i)) continue;
                keyRing.method_7939(0);
                inventory.method_5447(i, last);
                return Optional.of(keyStack);
            }
            inventory.method_7398(last);
        }
        if (keysNbt.isEmpty()) {
            keyRing.method_7939(0);
        }
        return Optional.of(keyStack);
    }

    private static boolean dropContents(class_1799 itemStack, class_1657 player) {
        class_2487 tag = itemStack.method_7948();
        if (!tag.method_10545("Keys")) {
            return false;
        }
        if (player instanceof class_3222) {
            class_2499 listTag = tag.method_10554("Keys", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                player.method_31548().method_7398(class_1799.method_7915((class_2487)listTag.method_10602(i)));
            }
        }
        itemStack.method_7983("Keys");
        return true;
    }

    private static void add(class_1799 keyRing, class_1799 key) {
        if (!keyRing.method_31574(LocksmithItems.KEYRING.get()) || !key.method_31574(LocksmithItems.KEY.get())) {
            return;
        }
        class_2487 tag = keyRing.method_7948();
        if (!tag.method_10545("Keys")) {
            tag.method_10566("Keys", (class_2520)new class_2499());
        }
        class_2499 keysNbt = tag.method_10554("Keys", 10);
        class_1799 singleKey = key.method_7971(1);
        class_2487 keyTag = new class_2487();
        singleKey.method_7953(keyTag);
        keysNbt.method_10531(0, (class_2520)keyTag);
    }

    private static boolean canAdd(class_1799 keyRing, class_1799 key) {
        if (!keyRing.method_31574(LocksmithItems.KEYRING.get()) || !key.method_31574(LocksmithItems.KEY.get())) {
            return false;
        }
        return keyRing.method_7969() == null || keyRing.method_7969().method_10573("Keys", 9) && keyRing.method_7969().method_10554("Keys", 10).size() < 4;
    }
}

