/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lock;

import com.mojang.serialization.DynamicOps;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.BlockLockPosition;
import gg.moonflower.locksmith.api.lock.position.EntityLockPosition;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.network.LocksmithMessages;
import gg.moonflower.locksmith.common.network.play.ClientboundAddLocksPacket;
import gg.moonflower.locksmith.common.network.play.ClientboundDeleteLocksPacket;
import gg.moonflower.pollen.api.event.events.entity.player.server.ServerPlayerTrackingEvents;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ServerLockManager
extends class_18
implements LockManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<class_1923, ChunkLockData> locks = new HashMap<class_1923, ChunkLockData>();
    private final ChunkLockData entityLocks = new ChunkLockData();
    private final class_3218 level;

    private ServerLockManager(class_3218 level) {
        this.level = level;
    }

    private ServerLockManager(class_3218 level, class_2487 nbt) {
        this(level);
        class_2499 chunks = nbt.method_10554("Chunks", 10);
        for (int i = 0; i < chunks.size(); ++i) {
            class_2487 lock = chunks.method_10602(i);
            ChunkLockData data = new ChunkLockData();
            data.load(lock);
            this.locks.put(new class_1923(lock.method_10550("X"), lock.method_10550("Z")), data);
        }
        this.entityLocks.load(nbt.method_10562("Entities"));
        this.entityLocks.locks.values().stream().map(AbstractLock::getPos).filter(EntityLockPosition.class::isInstance).map(EntityLockPosition.class::cast).forEach(pos -> pos.setEntity(() -> level.method_14190(pos.getEntityId())));
    }

    public static ServerLockManager getOrCreate(class_3218 level) {
        return (ServerLockManager)level.method_17983().method_17924(tag -> new ServerLockManager(level, (class_2487)tag), () -> new ServerLockManager(level), "locksmithLocks");
    }

    public static void init() {
        ServerPlayerTrackingEvents.START_TRACKING_CHUNK.register((player, chunk) -> {
            if (!(player.field_6002 instanceof class_3218) || !(player instanceof class_3222)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((class_3218)player.field_6002).getLocks(chunk);
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((class_3222)player, (PollinatedPacket)new ClientboundAddLocksPacket(locks, true));
        });
        ServerPlayerTrackingEvents.STOP_TRACKING_CHUNK.register((player, chunk) -> {
            if (!(player.field_6002 instanceof class_3218) || !(player instanceof class_3222)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((class_3218)player.field_6002).getLocks(chunk);
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((class_3222)player, (PollinatedPacket)new ClientboundDeleteLocksPacket(locks.stream().map(AbstractLock::getPos).collect(Collectors.toSet())));
        });
        ServerPlayerTrackingEvents.START_TRACKING_ENTITY.register((player, chunk) -> {
            if (!(player.field_6002 instanceof class_3218) || !(player instanceof class_3222)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((class_3218)((class_3218)player.field_6002)).entityLocks.getLocks();
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((class_3222)player, (PollinatedPacket)new ClientboundAddLocksPacket(locks, true));
        });
        ServerPlayerTrackingEvents.STOP_TRACKING_ENTITY.register((player, chunk) -> {
            if (!(player.field_6002 instanceof class_3218) || !(player instanceof class_3222)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((class_3218)((class_3218)player.field_6002)).entityLocks.getLocks();
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((class_3222)player, (PollinatedPacket)new ClientboundDeleteLocksPacket(locks.stream().map(AbstractLock::getPos).collect(Collectors.toSet())));
        });
    }

    private Collection<AbstractLock> getLocks(class_1923 chunkPos) {
        ChunkLockData chunk = this.locks.get(chunkPos);
        if (chunk == null) {
            return Collections.emptySet();
        }
        return chunk.getLocks();
    }

    @Override
    @Nullable
    public AbstractLock getLock(LockPosition pos) {
        ChunkLockData chunk = this.get(pos, false);
        if (chunk == null) {
            return null;
        }
        AbstractLock lock = chunk.getLock(pos);
        if (lock != null) {
            return lock;
        }
        if (pos instanceof BlockLockPosition) {
            class_2338 offsetPos = LockManager.getLockPosition((class_1937)this.level, pos.blockPosition());
            if (!pos.blockPosition().equals((Object)offsetPos)) {
                return chunk.getLock(LockPosition.of(offsetPos));
            }
        }
        return null;
    }

    @Override
    public void addLock(AbstractLock data) {
        ChunkLockData lockData = this.get(data.getPos(), true);
        LockPosition pos = data.getPos();
        if (pos instanceof BlockLockPosition) {
            LocksmithMessages.PLAY.sendToTracking(this.level, new class_1923(pos.blockPosition()), (PollinatedPacket)new ClientboundAddLocksPacket(Collections.singleton(data), false));
        } else {
            LocksmithMessages.PLAY.sendToTracking(((EntityLockPosition)pos).getEntity(), (PollinatedPacket)new ClientboundAddLocksPacket(Collections.singleton(data), false));
        }
        lockData.addLock(data);
        this.method_80();
    }

    private ChunkLockData get(LockPosition pos, boolean create) {
        if (pos instanceof BlockLockPosition) {
            class_1923 chunk = new class_1923(pos.blockPosition());
            ChunkLockData chunkData = this.locks.get(chunk);
            if (chunkData != null || !create) {
                return chunkData;
            }
            chunkData = new ChunkLockData();
            this.locks.put(chunk, chunkData);
            return chunkData;
        }
        return this.entityLocks;
    }

    private void removeLock(LockPosition pos, class_2338 clickPos, boolean drop) {
        ChunkLockData chunkData = this.get(pos, false);
        if (chunkData == null) {
            return;
        }
        AbstractLock lock = chunkData.removeLock(pos);
        if (lock == null) {
            return;
        }
        if (pos instanceof BlockLockPosition) {
            class_1799 lockStack;
            lock.onRemove((class_1937)this.level, pos.blockPosition(), clickPos);
            if (drop && !(lockStack = lock.getStack()).method_7960()) {
                class_2248.method_9577((class_1937)this.level, (class_2338)clickPos, (class_1799)lockStack);
            }
            LocksmithMessages.PLAY.sendToTracking(this.level, new class_1923(pos.blockPosition()), (PollinatedPacket)new ClientboundDeleteLocksPacket(Collections.singleton(pos)));
        } else {
            class_1799 lockStack;
            class_1297 entity = ((EntityLockPosition)pos).getEntity();
            lock.onRemove(entity);
            if (drop && !(lockStack = lock.getStack()).method_7960()) {
                class_2248.method_9577((class_1937)this.level, (class_2338)clickPos, (class_1799)lockStack);
            }
            LocksmithMessages.PLAY.sendToTracking(entity, (PollinatedPacket)new ClientboundDeleteLocksPacket(Collections.singleton(pos)));
        }
        this.method_80();
    }

    @Override
    public void removeLock(class_2338 pos, class_2338 clickPos, boolean drop) {
        this.removeLock(LockPosition.of(pos), clickPos, drop);
    }

    @Override
    public void removeLock(class_1297 entity, boolean drop) {
        this.removeLock(LockPosition.of(entity), entity.method_24515(), drop);
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 locksNbt = new class_2499();
        for (class_1923 pos : this.locks.keySet()) {
            class_2487 tag = new class_2487();
            tag.method_10569("X", pos.field_9181);
            tag.method_10569("Z", pos.field_9180);
            locksNbt.add((Object)this.locks.get(pos).save(tag));
        }
        nbt.method_10566("Chunks", (class_2520)locksNbt);
        nbt.method_10566("Entities", (class_2520)this.entityLocks.save(new class_2487()));
        return nbt;
    }

    private static class ChunkLockData {
        private final Map<LockPosition, AbstractLock> locks = new HashMap<LockPosition, AbstractLock>();

        private ChunkLockData() {
        }

        public void load(class_2487 compoundTag) {
            class_2499 tag = compoundTag.method_10554("Locks", 10);
            for (int i = 0; i < tag.size(); ++i) {
                AbstractLock lock = (AbstractLock)AbstractLock.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10602(i)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                this.locks.put(lock.getPos(), lock);
            }
        }

        public class_2487 save(class_2487 compoundTag) {
            class_2499 list = new class_2499();
            for (AbstractLock lock : this.locks.values()) {
                list.add((Object)((class_2520)AbstractLock.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)lock).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0))));
            }
            compoundTag.method_10566("Locks", (class_2520)list);
            return compoundTag;
        }

        public Collection<AbstractLock> getLocks() {
            return this.locks.values();
        }

        @Nullable
        public AbstractLock getLock(LockPosition pos) {
            return this.locks.get(pos);
        }

        public void addLock(AbstractLock lock) {
            this.locks.put(lock.getPos(), lock);
        }

        @Nullable
        public AbstractLock removeLock(LockPosition pos) {
            return this.locks.remove(pos);
        }
    }
}

