/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.core;

import gg.moonflower.locksmith.client.screen.KeyringScreen;
import gg.moonflower.locksmith.client.screen.LockPickingScreen;
import gg.moonflower.locksmith.client.screen.LocksmithingTableScreen;
import gg.moonflower.locksmith.client.tooltip.ClientKeyringTooltip;
import gg.moonflower.locksmith.common.item.KeyringItem;
import gg.moonflower.locksmith.common.lock.LockInteractionManager;
import gg.moonflower.locksmith.common.lock.ServerLockManager;
import gg.moonflower.locksmith.common.menu.LocksmithingTableMenu;
import gg.moonflower.locksmith.common.network.LocksmithMessages;
import gg.moonflower.locksmith.common.tooltip.KeyringTooltip;
import gg.moonflower.locksmith.core.LocksmithServerConfig;
import gg.moonflower.locksmith.core.datagen.LocksmithBlockTagsProvider;
import gg.moonflower.locksmith.core.datagen.LocksmithItemTagsProvider;
import gg.moonflower.locksmith.core.datagen.LocksmithLanguageProvider;
import gg.moonflower.locksmith.core.datagen.LocksmithRecipeProvider;
import gg.moonflower.locksmith.core.datagen.LocksmithSoundProvider;
import gg.moonflower.locksmith.core.registry.LocksmithBlocks;
import gg.moonflower.locksmith.core.registry.LocksmithItems;
import gg.moonflower.locksmith.core.registry.LocksmithLocks;
import gg.moonflower.locksmith.core.registry.LocksmithMenus;
import gg.moonflower.locksmith.core.registry.LocksmithParticles;
import gg.moonflower.locksmith.core.registry.LocksmithRecipes;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import gg.moonflower.locksmith.core.registry.LocksmithStats;
import gg.moonflower.pollen.api.config.ConfigManager;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.event.events.entity.player.PlayerInteractionEvents;
import gg.moonflower.pollen.api.event.events.registry.client.RegisterAtlasSpriteEvent;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.client.ClientTooltipComponentRegistry;
import gg.moonflower.pollen.api.registry.client.ItemPredicateRegistry;
import gg.moonflower.pollen.api.registry.client.ScreenRegistry;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2466;
import net.minecraft.class_2960;

public class Locksmith {
    public static final String MOD_ID = "locksmith";
    public static final LocksmithServerConfig CONFIG = (LocksmithServerConfig)ConfigManager.register((String)"locksmith", (PollinatedConfigType)PollinatedConfigType.SERVER, LocksmithServerConfig::new);
    public static final Platform PLATFORM = Platform.builder((String)"locksmith").clientInit(Locksmith::onClientInit).clientPostInit(Locksmith::onClientPostInit).commonInit(Locksmith::onCommonInit).commonPostInit(Locksmith::onCommonPostInit).dataInit(Locksmith::onDataInit).build();

    public static void onClientInit() {
        RegisterAtlasSpriteEvent.event((class_2960)class_1723.field_21668).register((atlas, registry) -> registry.accept(LocksmithingTableMenu.EMPTY_SLOT_KEY));
        LocksmithParticles.setupClient();
    }

    public static void onClientPostInit(Platform.ModSetupContext ctx) {
        ClientTooltipComponentRegistry.register(KeyringTooltip.class, ClientKeyringTooltip::new);
        ctx.enqueueWork(() -> {
            ScreenRegistry.register(LocksmithMenus.LOCKSMITHING_TABLE_MENU.get(), LocksmithingTableScreen::new);
            ScreenRegistry.register(LocksmithMenus.KEYRING_MENU.get(), KeyringScreen::new);
            ScreenRegistry.register(LocksmithMenus.LOCK_PICKING_MENU.get(), LockPickingScreen::new);
            ItemPredicateRegistry.register((class_1792)LocksmithItems.KEYRING.get(), (class_2960)new class_2960(MOD_ID, "keys"), (stack, level, livingEntity, i) -> (float)KeyringItem.getKeys(stack).size() / 4.0f);
        });
    }

    public static void onCommonInit() {
        LocksmithBlocks.BLOCKS.register(PLATFORM);
        LocksmithItems.ITEMS.register(PLATFORM);
        LocksmithSounds.SOUNDS.register(PLATFORM);
        LocksmithMenus.MENUS.register(PLATFORM);
        LocksmithParticles.PARTICLES.register(PLATFORM);
        LocksmithLocks.LOCKS.register(PLATFORM);
        LocksmithRecipes.RECIPES.register(PLATFORM);
        LocksmithRecipes.RECIPE_TYPES.register(PLATFORM);
        LocksmithMessages.init();
        ServerLockManager.init();
        PlayerInteractionEvents.RIGHT_CLICK_BLOCK.register(LockInteractionManager::onRightClickBlock);
        PlayerInteractionEvents.LEFT_CLICK_BLOCK.register(LockInteractionManager::onLeftClickBlock);
    }

    public static void onCommonPostInit(Platform.ModSetupContext ctx) {
        ctx.enqueueWork(() -> LocksmithStats.STATS.register(PLATFORM));
    }

    private static void onDataInit(Platform.DataSetupContext ctx) {
        class_2403 dataGenerator = ctx.getGenerator();
        PollinatedModContainer container = ctx.getMod();
        LocksmithBlockTagsProvider blockTagsProvider = new LocksmithBlockTagsProvider(dataGenerator, container);
        dataGenerator.method_10314((class_2405)blockTagsProvider);
        dataGenerator.method_10314((class_2405)new LocksmithItemTagsProvider(dataGenerator, container, (class_2466)blockTagsProvider));
        dataGenerator.method_10314((class_2405)new LocksmithLanguageProvider(dataGenerator, container));
        dataGenerator.method_10314((class_2405)new LocksmithSoundProvider(dataGenerator, container));
        dataGenerator.method_10314((class_2405)new LocksmithRecipeProvider(dataGenerator));
    }
}

