/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.api.lock;

import com.mojang.serialization.Codec;
import gg.moonflower.locksmith.api.lock.LockType;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.core.registry.LocksmithLocks;
import gg.moonflower.locksmith.core.registry.LocksmithParticles;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractLock {
    public static final Codec<AbstractLock> CODEC = LocksmithLocks.LOCKS.dispatch(AbstractLock::getType, LockType::codec);
    private final LockType type;
    private final UUID id;
    private final LockPosition pos;
    private final ItemStack stack;

    public AbstractLock(LockType type, UUID id, LockPosition pos, ItemStack stack) {
        this.type = type;
        this.id = id;
        this.pos = pos;
        this.stack = stack;
    }

    public UUID getId() {
        return this.id;
    }

    public LockPosition getPos() {
        return this.pos;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public LockType getType() {
        return this.type;
    }

    public void onRemove(World level, BlockPos pos, BlockPos clickPos) {
        level.func_180495_p(clickPos).func_199611_f((IBlockReader)level, pos, ISelectionContext.func_216377_a()).func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double d1 = Math.min(1.0, maxX - minX);
            double d2 = Math.min(1.0, maxY - minY);
            double d3 = Math.min(1.0, maxZ - minZ);
            int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.4)));
            int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.4)));
            int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.4)));
            ((ServerWorld)level).func_195598_a((IParticleData)LocksmithParticles.LOCK_BREAK.get(), (double)pos.func_177958_n() + minX + maxX / 2.0, (double)pos.func_177956_o() + minY + maxY / 2.0, (double)pos.func_177952_p() + minZ + maxZ / 2.0, i * j * k, (maxX - minX) / 4.0 + 0.0625, (maxY - minY) / 4.0 + 0.0625, (maxZ - minZ) / 4.0 + 0.0625, 0.0);
        });
    }

    public void onRemove(Entity entity) {
        double d1 = Math.min(1.0, (double)entity.func_213311_cf());
        double d2 = Math.min(1.0, (double)entity.func_213302_cg());
        double d3 = Math.min(1.0, (double)entity.func_213311_cf());
        int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.4)));
        int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.4)));
        int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.4)));
        ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)LocksmithParticles.LOCK_BREAK.get(), entity.func_226277_ct_(), entity.func_226283_e_(0.5), entity.func_226281_cx_(), i * j * k, (double)entity.func_213311_cf() / 4.0 + 0.0625, (double)entity.func_213302_cg() / 4.0 + 0.0625, (double)entity.func_213311_cf() / 4.0 + 0.0625, 0.0);
    }

    public abstract boolean canRemove(PlayerEntity var1, World var2, ItemStack var3);

    public abstract boolean pick(PlayerEntity var1, World var2, LockPosition var3, ItemStack var4, Hand var5);

    public abstract boolean canUnlock(PlayerEntity var1, World var2, ItemStack var3);

    public abstract boolean onRightClick(PlayerEntity var1, World var2, ItemStack var3, BlockRayTraceResult var4);

    public abstract boolean onLeftClick(PlayerEntity var1, World var2, Hand var3, BlockPos var4, Direction var5);

    public abstract boolean onRightClick(PlayerEntity var1, World var2, ItemStack var3, Entity var4);

    public abstract boolean onLeftClick(PlayerEntity var1, World var2, Hand var3, Entity var4);
}

