/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.api.lock.position;

import com.mojang.serialization.Codec;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.util.UUIDCodec;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public class EntityLockPosition
implements LockPosition {
    public static final Codec<EntityLockPosition> CODEC = UUIDCodec.field_239775_a_.xmap(EntityLockPosition::new, pos -> pos.entity.get().func_110124_au());
    private Supplier<Entity> entity;
    private final UUID entityId;
    private final int hashCode;

    private EntityLockPosition(UUID entityId) {
        this.entity = null;
        this.entityId = entityId;
        this.hashCode = entityId.hashCode();
    }

    EntityLockPosition(UUID entityId, Supplier<Entity> entity) {
        this.entity = entity;
        this.entityId = entityId;
        this.hashCode = entityId.hashCode();
    }

    EntityLockPosition(int entityId, Supplier<Entity> entity) {
        this.entity = entity;
        this.entityId = null;
        this.hashCode = entityId;
    }

    @Override
    public BlockPos blockPosition() {
        return this.entity.get().func_233580_cy_();
    }

    @Override
    public Vector3d position() {
        return this.entity.get().func_213303_ch();
    }

    public Entity getEntity() {
        return this.entity.get();
    }

    public UUID getEntityId() {
        return this.entityId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityLockPosition that = (EntityLockPosition)o;
        Entity thisEntity = this.getEntity();
        Entity thatEntity = that.getEntity();
        return thisEntity != null && thatEntity != null ? thisEntity.equals((Object)thatEntity) : this.entityId.equals(that.entityId);
    }

    @ApiStatus.Internal
    public void setEntity(Supplier<Entity> entity) {
        Validate.isTrue((this.entity == null ? 1 : 0) != 0);
        this.entity = entity;
    }
}

