/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.api.lock.position;

import com.mojang.serialization.Codec;
import gg.moonflower.locksmith.api.lock.position.BlockLockPosition;
import gg.moonflower.locksmith.api.lock.position.EntityLockPosition;
import gg.moonflower.locksmith.common.lock.LockPositionCodec;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface LockPosition {
    public static final Codec<LockPosition> CODEC = LockPositionCodec.create();

    public BlockPos blockPosition();

    public Vector3d position();

    public static LockPosition of(BlockPos pos) {
        return new BlockLockPosition(pos);
    }

    public static LockPosition of(Entity entity) {
        return new EntityLockPosition(entity.func_110124_au(), () -> entity);
    }

    public static LockPosition of(ServerWorld level, UUID entityId) {
        return new EntityLockPosition(entityId, () -> level.func_217461_a(entityId));
    }

    public static LockPosition of(World level, int entityId) {
        return new EntityLockPosition(entityId, () -> level.func_73045_a(entityId));
    }
}

