/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.client.lock;

import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.BlockLockPosition;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.pollen.api.event.events.network.ClientNetworkEvents;
import gg.moonflower.pollen.api.event.events.world.ChunkEvents;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public final class ClientLockManager
implements LockManager {
    private static final Map<RegistryKey<World>, ClientLockManager> INSTANCES = new HashMap<RegistryKey<World>, ClientLockManager>();
    private final Map<LockPosition, AbstractLock> locks = new HashMap<LockPosition, AbstractLock>();
    private final ClientWorld level;

    private ClientLockManager(ClientWorld level) {
        this.level = level;
    }

    public static ClientLockManager getOrCreate(ClientWorld level) {
        return INSTANCES.computeIfAbsent((RegistryKey<World>)level.func_234923_W_(), levelResourceKey -> new ClientLockManager(level));
    }

    @Override
    @Nullable
    public AbstractLock getLock(LockPosition pos) {
        AbstractLock lock = this.locks.get(pos);
        if (lock != null) {
            return lock;
        }
        if (pos instanceof BlockLockPosition) {
            BlockPos offsetPos = LockManager.getLockPosition((World)this.level, pos.blockPosition());
            if (!pos.blockPosition().equals((Object)offsetPos)) {
                return this.locks.get(LockPosition.of(offsetPos));
            }
        }
        return null;
    }

    @Override
    public void addLock(AbstractLock data) {
        this.locks.put(data.getPos(), data);
    }

    private void removeLock(LockPosition pos) {
        this.locks.remove(pos);
    }

    @Override
    public void removeLock(BlockPos pos, BlockPos clickPos, boolean drop) {
        this.removeLock(LockPosition.of(pos));
    }

    @Override
    public void removeLock(Entity entity, boolean drop) {
        this.removeLock(LockPosition.of(entity));
    }

    public void clearLocks(ChunkPos chunk) {
        this.locks.values().removeIf(lock -> lock.getPos() instanceof BlockLockPosition && lock.getPos().blockPosition().func_177958_n() >> 4 == chunk.field_77276_a && lock.getPos().blockPosition().func_177952_p() >> 4 == chunk.field_77275_b);
    }

    static {
        ClientNetworkEvents.LOGOUT.register((controller, player, connection) -> INSTANCES.clear());
        ChunkEvents.UNLOAD.register((level, chunk) -> {
            if (level instanceof World) {
                ClientLockManager manager = INSTANCES.get(((World)level).func_234923_W_());
                if (manager == null) {
                    return;
                }
                manager.clearLocks(chunk.func_76632_l());
            }
        });
    }
}

