/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.menu.LockpickingMenu;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import gg.moonflower.pollen.api.client.render.ShapeRenderer;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class LockPickingScreen
extends ContainerScreen<LockpickingMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("locksmith", "textures/gui/lockpicking.png");
    private static final float MOVE_SPEED = 0.8f;
    private final LockPickingContext context;
    private float lastPickIndex;
    private int pickIndex;
    private boolean raised;
    private boolean deferRaised;
    private float lastPickProgress;
    private float pickProgress;

    public LockPickingScreen(LockpickingMenu menu, PlayerInventory inventory, ITextComponent title) {
        super((Container)menu, inventory, title);
        this.context = menu.getContext();
        this.field_146999_f = 104;
        this.field_147000_g = 34;
    }

    public void lowerPick() {
        this.raised = false;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.lastPickProgress = this.pickProgress;
        if (this.context.getState() != LockPickingContext.GameState.RUNNING) {
            return;
        }
        if (this.pickProgress < 1.0f) {
            this.pickProgress += 0.8f;
            if (this.pickProgress > 1.0f) {
                this.pickProgress = 1.0f;
            }
            if (this.pickProgress >= 1.0f && this.deferRaised) {
                this.deferRaised = false;
                this.context.pick(this.pickIndex);
            }
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        int selectedIndex;
        partialTicks = this.field_230706_i_.func_184121_ak();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        IVertexBuilder builder = ShapeRenderer.begin();
        ShapeRenderer.drawRectWithTexture((IVertexBuilder)builder, (MatrixStack)matrixStack, (float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f, (float)0.0f, (float)this.field_146999_f, (float)this.field_147000_g, (float)this.field_146999_f, (float)this.field_147000_g, (float)128.0f, (float)128.0f);
        for (int i = 0; i < 5; ++i) {
            ShapeRenderer.drawRectWithTexture((IVertexBuilder)builder, (MatrixStack)matrixStack, (float)(this.field_147003_i + i * 18 + 10), (float)(this.field_147009_r + this.field_147000_g - 3), (float)(104 + (this.context.getPinState(i) ? 12 : 0)), (float)0.0f, (float)12.0f, (float)10.0f, (float)12.0f, (float)10.0f, (float)128.0f, (float)128.0f);
        }
        if (this.context.getState() == LockPickingContext.GameState.RUNNING && (selectedIndex = (mouseX - this.field_147003_i - 11) / 18) >= 0 && selectedIndex < 5 && this.func_195359_a(12 + selectedIndex * 18, 32, 8, 10, mouseX, mouseY)) {
            ShapeRenderer.drawRectWithTexture((IVertexBuilder)builder, (MatrixStack)matrixStack, (float)(this.field_147003_i + selectedIndex * 18 + 10), (float)(this.field_147009_r + this.field_147000_g - 3), (float)(104 + (this.context.getPinState(selectedIndex) ? 12 : 0)), (float)10.0f, (float)12.0f, (float)10.0f, (float)12.0f, (float)10.0f, (float)128.0f, (float)128.0f);
        }
        float x = this.getRenderPickIndex(partialTicks) * 18.0f - 27.0f;
        float y = !(this.getPickProgress(partialTicks) != 1.0f && this.context.getPinState((int)this.lastPickIndex) != this.context.getPinState(this.pickIndex) || !this.raised && !this.context.getPinState(this.pickIndex)) ? -2.0f : 0.0f;
        ShapeRenderer.drawRectWithTexture((IVertexBuilder)builder, (MatrixStack)matrixStack, (float)(this.field_147003_i + (int)x), (float)(this.field_147009_r + this.field_147000_g + (int)y + 7), (float)0.0f, (float)(34 + this.context.getPickDamage() * 18), (float)46.0f, (float)18.0f, (float)46.0f, (float)18.0f, (float)128.0f, (float)128.0f);
        ShapeRenderer.end();
    }

    protected void func_230451_b_(MatrixStack poseStack, int mouseX, int mouseY) {
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int selectedIndex;
        if (button == 0 && this.context.getState() == LockPickingContext.GameState.RUNNING && !this.raised && (selectedIndex = (int)((mouseX - (double)this.field_147003_i - 11.0) / 18.0)) >= 0 && selectedIndex < 5 && this.func_195359_a(12 + selectedIndex * 18, 32, 8, 10, mouseX, mouseY)) {
            this.lastPickIndex = this.getRenderPickIndex(1.0f);
            this.lastPickProgress = 0.0f;
            this.pickProgress = 0.0f;
            this.pickIndex = selectedIndex;
            if (!this.context.getPinState(this.pickIndex)) {
                this.raised = true;
                if (this.pickProgress == 1.0f) {
                    this.context.pick(this.pickIndex);
                } else {
                    this.deferRaised = true;
                }
            }
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.context.getState() == LockPickingContext.GameState.RUNNING && !this.raised) {
            if (keyCode == 65 || keyCode == 263) {
                if (this.pickIndex < 1) {
                    this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)LocksmithSounds.LOCK_PICKING_TOO_NEAR.get(), (float)1.0f));
                    return true;
                }
                this.lastPickIndex = this.getRenderPickIndex(1.0f);
                this.lastPickProgress = 0.0f;
                this.pickProgress = 0.0f;
                --this.pickIndex;
                return true;
            }
            if (keyCode == 68 || keyCode == 262) {
                if (this.pickIndex >= 4) {
                    this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)LocksmithSounds.LOCK_PICKING_TOO_FAR.get(), (float)1.0f));
                    return true;
                }
                this.lastPickIndex = this.getRenderPickIndex(1.0f);
                this.lastPickProgress = 0.0f;
                this.pickProgress = 0.0f;
                ++this.pickIndex;
                return true;
            }
            if (keyCode == 32 && !this.context.getPinState(this.pickIndex)) {
                this.raised = true;
                if (this.pickProgress == 1.0f) {
                    this.context.pick(this.pickIndex);
                } else {
                    this.deferRaised = true;
                }
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private float getPickProgress(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastPickProgress, (float)this.pickProgress);
    }

    private float getRenderPickIndex(float partialTicks) {
        return MathHelper.func_219799_g((float)this.getPickProgress(partialTicks), (float)this.lastPickIndex, (float)this.pickIndex);
    }
}

