/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.item;

import gg.moonflower.locksmith.api.key.Key;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.core.registry.LocksmithTags;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class KeyItem
extends Item
implements Key {
    private static final ITextComponent ORIGINAL = new TranslationTextComponent("item.locksmith.key.original").func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent COPY = new TranslationTextComponent("item.locksmith.key.copy").func_240699_a_(TextFormatting.GRAY);

    public KeyItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean matchesLock(UUID id, ItemStack stack) {
        return id.equals(KeyItem.getLockId(stack));
    }

    public static boolean canHaveLock(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(LocksmithTags.LOCKING);
    }

    public static boolean isKey(ItemStack stack) {
        return !stack.func_77973_b().func_206844_a(LocksmithTags.BLANK_KEY) && stack.func_77973_b() instanceof Key;
    }

    public static boolean isBlankKey(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(LocksmithTags.BLANK_KEY);
    }

    public static boolean hasLockId(ItemStack stack) {
        if (stack.func_77978_p() == null || !KeyItem.canHaveLock(stack)) {
            return false;
        }
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_186855_b("Lock");
    }

    @Nullable
    public static UUID getLockId(ItemStack stack) {
        if (stack.func_77978_p() == null || !KeyItem.canHaveLock(stack)) {
            return null;
        }
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_186855_b("Lock") ? tag.func_186857_a("Lock") : null;
    }

    public static void setLockId(ItemStack stack, @Nullable UUID id) {
        if (KeyItem.canHaveLock(stack)) {
            if (stack.func_77978_p() == null && id == null) {
                return;
            }
            if (id == null) {
                stack.func_77978_p().func_82580_o("Lock");
                if (stack.func_77978_p().isEmpty()) {
                    stack.func_77982_d(null);
                }
                return;
            }
            stack.func_196082_o().func_186854_a("Lock", id);
        }
    }

    public static boolean isOriginal(ItemStack stack) {
        return KeyItem.isKey(stack) && KeyItem.hasLockId(stack) && stack.func_196082_o().func_74767_n("Original");
    }

    public static void setOriginal(ItemStack stack, boolean original) {
        if (KeyItem.isKey(stack) && KeyItem.hasLockId(stack)) {
            stack.func_196082_o().func_74757_a("Original", original);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        World level = context.func_195991_k();
        AbstractLock abstractLock = LockManager.get(level).getLock(LockPosition.of(pos));
        if (player == null || abstractLock == null) {
            return ActionResultType.PASS;
        }
        if (abstractLock.canRemove(player, level, context.func_195996_i())) {
            if (level.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            LockManager.get(level).removeLock(abstractLock.getPos().blockPosition(), pos, true);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> tooltipComponents, ITooltipFlag isAdvanced) {
        if (level != null) {
            tooltipComponents.add(KeyItem.isOriginal(stack) ? ORIGINAL : COPY);
        }
        if (isAdvanced.func_194127_a()) {
            UUID id = KeyItem.getLockId(stack);
            if (id == null || Util.field_240973_b_.equals(id)) {
                return;
            }
            tooltipComponents.add((ITextComponent)new StringTextComponent("Lock Id: " + id).func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }
}

