/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.item;

import gg.moonflower.locksmith.api.key.Key;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.menu.KeyringMenu;
import gg.moonflower.locksmith.core.registry.LocksmithItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class KeyringItem
extends Item
implements Key {
    public static final int MAX_KEYS = 4;

    public KeyringItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean matchesLock(UUID id, ItemStack stack) {
        for (ItemStack key : KeyringItem.getKeys(stack)) {
            if (!id.equals(KeyItem.getLockId(key))) continue;
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        final ItemStack stack = player.func_184586_b(hand);
        if (player.func_226563_dT_()) {
            final int index = player.field_71071_by.func_184429_b(stack);
            if (index == -1) {
                return ActionResult.func_226250_c_((Object)stack);
            }
            if (!level.func_201670_d()) {
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                player.func_213829_a(new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return stack.func_200301_q();
                    }

                    public Container createMenu(int containerId, PlayerInventory inventory, PlayerEntity player) {
                        return new KeyringMenu(containerId, player.field_71071_by, index);
                    }
                });
            }
            return ActionResult.func_233538_a_((Object)stack, (boolean)level.func_201670_d());
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        World level = context.func_195991_k();
        AbstractLock lock = LockManager.get(level).getLock(LockPosition.of(pos));
        if (player == null || lock == null) {
            return ActionResultType.PASS;
        }
        for (ItemStack key : KeyringItem.getKeys(context.func_195996_i())) {
            if (!lock.canRemove(player, level, key)) continue;
            if (level.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            LockManager.get(level).removeLock(lock.getPos().blockPosition(), pos, true);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public static List<ItemStack> getKeys(ItemStack stack) {
        if (stack.func_77973_b() != LocksmithItems.KEYRING.get()) {
            return Collections.emptyList();
        }
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Keys", 9)) {
            return Collections.emptyList();
        }
        ListNBT keysNbt = nbt.func_150295_c("Keys", 10);
        if (keysNbt.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(keysNbt.size());
        for (int i = 0; i < Math.min(4, keysNbt.size()); ++i) {
            ItemStack key = ItemStack.func_199557_a((CompoundNBT)keysNbt.func_150305_b(i));
            if (key.func_190926_b()) continue;
            list.add(key);
        }
        return list;
    }

    public static void setKeys(ItemStack stack, Collection<ItemStack> keys) {
        if (stack.func_77973_b() != LocksmithItems.KEYRING.get() || keys.isEmpty()) {
            return;
        }
        CompoundNBT nbt = stack.func_196082_o();
        ListNBT keysNbt = new ListNBT();
        int i = 0;
        for (ItemStack key : keys) {
            if (key.func_190926_b()) continue;
            if (i >= 4) break;
            keysNbt.add((Object)key.func_77955_b(new CompoundNBT()));
            ++i;
        }
        nbt.func_218657_a("Keys", (INBT)keysNbt);
    }
}

