/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.item;

import com.google.gson.JsonParseException;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.lock.types.KeyLock;
import gg.moonflower.locksmith.core.registry.LocksmithParticles;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import gg.moonflower.locksmith.core.registry.LocksmithTags;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class LockItem
extends Item {
    public LockItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        UUID lockId = KeyItem.getLockId(stack);
        BlockPos pos = context.func_195995_a();
        World level = context.func_195991_k();
        if (LockManager.get(level).getLock(LockPosition.of(pos)) != null || lockId == null || !level.func_180495_p(pos).func_235714_a_(LocksmithTags.LOCKABLE_BLOCKS)) {
            return ActionResultType.PASS;
        }
        if (level.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack lockStack = stack.func_77946_l();
        lockStack.func_190920_e(1);
        LockManager.get(level).addLock(new KeyLock(lockId, LockPosition.of(pos), lockStack));
        level.func_184133_a(null, pos, LocksmithSounds.ITEM_LOCK_PLACE.get(), SoundCategory.BLOCKS, 0.75f, 1.0f);
        level.func_180495_p(pos).func_199611_f((IBlockReader)level, pos, ISelectionContext.func_216377_a()).func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double d1 = Math.min(1.0, maxX - minX);
            double d2 = Math.min(1.0, maxY - minY);
            double d3 = Math.min(1.0, maxZ - minZ);
            int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.4)));
            int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.4)));
            int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.4)));
            ((ServerWorld)level).func_195598_a((IParticleData)LocksmithParticles.LOCK_SPARK.get(), (double)pos.func_177958_n() + minX + maxX / 2.0, (double)pos.func_177956_o() + minY + maxY / 2.0, (double)pos.func_177952_p() + minZ + maxZ / 2.0, i * j * k, (maxX - minX) / 4.0 + 0.0625, (maxY - minY) / 4.0 + 0.0625, (maxZ - minZ) / 4.0 + 0.0625, 0.0);
        });
        PlayerEntity player = context.func_195999_j();
        if (player != null) {
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
        return ActionResultType.CONSUME;
    }

    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> tooltipComponents, ITooltipFlag isAdvanced) {
        LockItem.getKeyName(stack).ifPresent(name -> tooltipComponents.add((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".key", new Object[]{name.func_230532_e_().func_240699_a_(TextFormatting.GRAY)})));
        if (isAdvanced.func_194127_a()) {
            UUID id = KeyItem.getLockId(stack);
            if (id == null) {
                return;
            }
            tooltipComponents.add((ITextComponent)new StringTextComponent("Lock Id: " + id).func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }

    public static Optional<ITextComponent> getKeyName(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof LockItem)) {
            return Optional.empty();
        }
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("KeyName", 8)) {
            return Optional.empty();
        }
        try {
            IFormattableTextComponent component = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("KeyName"));
            if (component != null) {
                return Optional.of(component);
            }
            nbt.func_82580_o("KeyName");
        }
        catch (JsonParseException e) {
            nbt.func_82580_o("KeyName");
        }
        return Optional.empty();
    }

    public static void setKeyName(ItemStack stack, @Nullable ITextComponent name) {
        if (!(stack.func_77973_b() instanceof LockItem)) {
            return;
        }
        if (name == null) {
            stack.func_196083_e("KeyName");
            return;
        }
        stack.func_196082_o().func_74778_a("KeyName", ITextComponent.Serializer.func_150696_a((ITextComponent)name));
    }
}

