/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lock;

import com.mojang.serialization.DynamicOps;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.core.Locksmith;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockInteractionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ITextComponent LOCKED = new TranslationTextComponent("lock.locksmith.locked");

    public static ActionResultType onRightClickBlock(PlayerEntity player, World level, Hand hand, BlockRayTraceResult hitResult) {
        BlockPos pos = hitResult.func_216350_a();
        LockPosition lockPosition = LockPosition.of(pos);
        AbstractLock lock = LockManager.get(level).getLock(lockPosition);
        if (lock == null || player.func_184812_l_()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (((Boolean)Locksmith.CONFIG.enableLockpicking.get()).booleanValue() && lock.pick(player, level, lockPosition, stack, hand)) {
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
            return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
        }
        if (!(lock.onRightClick(player, level, stack, hitResult) || hand != Hand.OFF_HAND && lock.onRightClick(player, level, player.func_184592_cb(), hitResult))) {
            player.func_146105_b(LOCKED, true);
            if (level.func_201670_d()) {
                player.func_213823_a(LocksmithSounds.ITEM_LOCK_LOCKED.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(hand);
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType onLeftClickBlock(PlayerEntity player, World level, Hand hand, BlockPos pos, Direction direction) {
        AbstractLock lock = LockManager.get(level).getLock(LockPosition.of(pos));
        if (lock == null || player.func_184812_l_()) {
            return ActionResultType.PASS;
        }
        if (lock.onLeftClick(player, level, hand, pos, direction)) {
            return ActionResultType.PASS;
        }
        player.func_146105_b(LOCKED, true);
        return ActionResultType.FAIL;
    }

    public static void onBreakBlock(World level, BlockPos pos, BlockState state) {
        AbstractLock lock = LockManager.get(level).getLock(LockPosition.of(pos));
        if (lock == null) {
            return;
        }
        if (state.func_235901_b_((Property)ChestBlock.field_196314_b) && state.func_177229_b((Property)ChestBlock.field_196314_b) != ChestType.SINGLE) {
            INBT tag = (INBT)AbstractLock.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)lock).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
            if (!(tag instanceof CompoundNBT)) {
                return;
            }
            CompoundNBT lockTag = (CompoundNBT)tag;
            lockTag.func_218657_a("pos", (INBT)BlockPos.field_239578_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)lock.getPos().blockPosition().func_177972_a(ChestBlock.func_196311_i((BlockState)state))).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
            AbstractLock newLock = (AbstractLock)AbstractLock.CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)lockTag).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
            LockManager.get(level).addLock(newLock);
            return;
        }
        LockManager.get(level).removeLock(lock.getPos().blockPosition(), pos, false);
    }
}

