/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lock;

import com.mojang.serialization.DynamicOps;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.BlockLockPosition;
import gg.moonflower.locksmith.api.lock.position.EntityLockPosition;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.network.LocksmithMessages;
import gg.moonflower.locksmith.common.network.play.ClientboundAddLocksPacket;
import gg.moonflower.locksmith.common.network.play.ClientboundDeleteLocksPacket;
import gg.moonflower.pollen.api.event.events.entity.player.server.ServerPlayerTrackingEvents;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ServerLockManager
extends WorldSavedData
implements LockManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ChunkPos, ChunkLockData> locks = new HashMap<ChunkPos, ChunkLockData>();
    private final ChunkLockData entityLocks = new ChunkLockData();
    private final ServerWorld level;

    private ServerLockManager(ServerWorld level) {
        super("locksmithLocks");
        this.level = level;
    }

    public static ServerLockManager getOrCreate(ServerWorld level) {
        return (ServerLockManager)level.func_217481_x().func_215752_a(() -> new ServerLockManager(level), "locksmithLocks");
    }

    public static void init() {
        ServerPlayerTrackingEvents.START_TRACKING_CHUNK.register((player, chunk) -> {
            if (!(player.field_70170_p instanceof ServerWorld) || !(player instanceof ServerPlayerEntity)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((ServerWorld)player.field_70170_p).getLocks(chunk);
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((ServerPlayerEntity)player, (PollinatedPacket)new ClientboundAddLocksPacket(locks, true));
        });
        ServerPlayerTrackingEvents.STOP_TRACKING_CHUNK.register((player, chunk) -> {
            if (!(player.field_70170_p instanceof ServerWorld) || !(player instanceof ServerPlayerEntity)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((ServerWorld)player.field_70170_p).getLocks(chunk);
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((ServerPlayerEntity)player, (PollinatedPacket)new ClientboundDeleteLocksPacket(locks.stream().map(AbstractLock::getPos).collect(Collectors.toSet())));
        });
        ServerPlayerTrackingEvents.START_TRACKING_ENTITY.register((player, chunk) -> {
            if (!(player.field_70170_p instanceof ServerWorld) || !(player instanceof ServerPlayerEntity)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((ServerWorld)((ServerWorld)player.field_70170_p)).entityLocks.getLocks();
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((ServerPlayerEntity)player, (PollinatedPacket)new ClientboundAddLocksPacket(locks, true));
        });
        ServerPlayerTrackingEvents.STOP_TRACKING_ENTITY.register((player, chunk) -> {
            if (!(player.field_70170_p instanceof ServerWorld) || !(player instanceof ServerPlayerEntity)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((ServerWorld)((ServerWorld)player.field_70170_p)).entityLocks.getLocks();
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((ServerPlayerEntity)player, (PollinatedPacket)new ClientboundDeleteLocksPacket(locks.stream().map(AbstractLock::getPos).collect(Collectors.toSet())));
        });
    }

    private Collection<AbstractLock> getLocks(ChunkPos chunkPos) {
        ChunkLockData chunk = this.locks.get(chunkPos);
        if (chunk == null) {
            return Collections.emptySet();
        }
        return chunk.getLocks();
    }

    @Override
    @Nullable
    public AbstractLock getLock(LockPosition pos) {
        ChunkLockData chunk = this.get(pos, false);
        if (chunk == null) {
            return null;
        }
        AbstractLock lock = chunk.getLock(pos);
        if (lock != null) {
            return lock;
        }
        if (pos instanceof BlockLockPosition) {
            BlockPos offsetPos = LockManager.getLockPosition((World)this.level, pos.blockPosition());
            if (!pos.blockPosition().equals((Object)offsetPos)) {
                return chunk.getLock(LockPosition.of(offsetPos));
            }
        }
        return null;
    }

    @Override
    public void addLock(AbstractLock data) {
        ChunkLockData lockData = this.get(data.getPos(), true);
        LockPosition pos = data.getPos();
        if (pos instanceof BlockLockPosition) {
            LocksmithMessages.PLAY.sendToTracking(this.level, new ChunkPos(pos.blockPosition()), (PollinatedPacket)new ClientboundAddLocksPacket(Collections.singleton(data), false));
        } else {
            LocksmithMessages.PLAY.sendToTracking(((EntityLockPosition)pos).getEntity(), (PollinatedPacket)new ClientboundAddLocksPacket(Collections.singleton(data), false));
        }
        lockData.addLock(data);
        this.func_76185_a();
    }

    private ChunkLockData get(LockPosition pos, boolean create) {
        if (pos instanceof BlockLockPosition) {
            ChunkPos chunk = new ChunkPos(pos.blockPosition());
            ChunkLockData chunkData = this.locks.get(chunk);
            if (chunkData != null || !create) {
                return chunkData;
            }
            chunkData = new ChunkLockData();
            this.locks.put(chunk, chunkData);
            return chunkData;
        }
        return this.entityLocks;
    }

    private void removeLock(LockPosition pos, BlockPos clickPos, boolean drop) {
        ChunkLockData chunkData = this.get(pos, false);
        if (chunkData == null) {
            return;
        }
        AbstractLock lock = chunkData.removeLock(pos);
        if (lock == null) {
            return;
        }
        if (pos instanceof BlockLockPosition) {
            ItemStack lockStack;
            lock.onRemove((World)this.level, pos.blockPosition(), clickPos);
            if (drop && !(lockStack = lock.getStack()).func_190926_b()) {
                Block.func_180635_a((World)this.level, (BlockPos)clickPos, (ItemStack)lockStack);
            }
            LocksmithMessages.PLAY.sendToTracking(this.level, new ChunkPos(pos.blockPosition()), (PollinatedPacket)new ClientboundDeleteLocksPacket(Collections.singleton(pos)));
        } else {
            ItemStack lockStack;
            Entity entity = ((EntityLockPosition)pos).getEntity();
            lock.onRemove(entity);
            if (drop && !(lockStack = lock.getStack()).func_190926_b()) {
                Block.func_180635_a((World)this.level, (BlockPos)clickPos, (ItemStack)lockStack);
            }
            LocksmithMessages.PLAY.sendToTracking(entity, (PollinatedPacket)new ClientboundDeleteLocksPacket(Collections.singleton(pos)));
        }
        this.func_76185_a();
    }

    @Override
    public void removeLock(BlockPos pos, BlockPos clickPos, boolean drop) {
        this.removeLock(LockPosition.of(pos), clickPos, drop);
    }

    @Override
    public void removeLock(Entity entity, boolean drop) {
        this.removeLock(LockPosition.of(entity), entity.func_233580_cy_(), drop);
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT tag = nbt.func_150295_c("Chunks", 10);
        for (int i = 0; i < tag.size(); ++i) {
            CompoundNBT lock = tag.func_150305_b(i);
            ChunkLockData data = new ChunkLockData();
            data.load(lock);
            this.locks.put(new ChunkPos(lock.func_74762_e("X"), lock.func_74762_e("Z")), data);
        }
        this.entityLocks.load(nbt.func_74775_l("Entities"));
        this.entityLocks.locks.values().stream().map(AbstractLock::getPos).filter(EntityLockPosition.class::isInstance).map(EntityLockPosition.class::cast).forEach(pos -> pos.setEntity(() -> this.level.func_217461_a(pos.getEntityId())));
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        ListNBT locksNbt = new ListNBT();
        for (ChunkPos pos : this.locks.keySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("X", pos.field_77276_a);
            tag.func_74768_a("Z", pos.field_77275_b);
            locksNbt.add((Object)this.locks.get(pos).save(tag));
        }
        nbt.func_218657_a("Chunks", (INBT)locksNbt);
        nbt.func_218657_a("Entities", (INBT)this.entityLocks.save(new CompoundNBT()));
        return nbt;
    }

    private static class ChunkLockData {
        private final Map<LockPosition, AbstractLock> locks = new HashMap<LockPosition, AbstractLock>();

        private ChunkLockData() {
        }

        public void load(CompoundNBT compoundTag) {
            ListNBT tag = compoundTag.func_150295_c("Locks", 10);
            for (int i = 0; i < tag.size(); ++i) {
                AbstractLock lock = (AbstractLock)AbstractLock.CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tag.func_150305_b(i)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                this.locks.put(lock.getPos(), lock);
            }
        }

        public CompoundNBT save(CompoundNBT compoundTag) {
            ListNBT list = new ListNBT();
            for (AbstractLock lock : this.locks.values()) {
                list.add((Object)((INBT)AbstractLock.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)lock).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0))));
            }
            compoundTag.func_218657_a("Locks", (INBT)list);
            return compoundTag;
        }

        public Collection<AbstractLock> getLocks() {
            return this.locks.values();
        }

        @Nullable
        public AbstractLock getLock(LockPosition pos) {
            return this.locks.get(pos);
        }

        public void addLock(AbstractLock lock) {
            this.locks.put(lock.getPos(), lock);
        }

        @Nullable
        public AbstractLock removeLock(LockPosition pos) {
            return this.locks.remove(pos);
        }
    }
}

