/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lock.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.locksmith.api.key.Key;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockType;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.menu.LockpickingMenu;
import gg.moonflower.locksmith.core.Locksmith;
import gg.moonflower.locksmith.core.registry.LocksmithItems;
import gg.moonflower.locksmith.core.registry.LocksmithLocks;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.UUIDCodec;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class KeyLock
extends AbstractLock {
    public static final Codec<KeyLock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDCodec.field_239775_a_.fieldOf("id").forGetter(AbstractLock::getId), (App)LockPosition.CODEC.fieldOf("pos").forGetter(AbstractLock::getPos), (App)ItemStack.field_234691_a_.fieldOf("stack").forGetter(AbstractLock::getStack)).apply((Applicative)instance, KeyLock::new));
    private static final ITextComponent LOCK_PICKING = new TranslationTextComponent("container.locksmith.lock_picking");

    public KeyLock(LockType type, UUID id, LockPosition pos, ItemStack stack) {
        super(type, id, pos, stack);
    }

    public KeyLock(UUID id, LockPosition pos, ItemStack stack) {
        this(LocksmithLocks.KEY.get(), id, pos, stack);
    }

    @Override
    public boolean canRemove(PlayerEntity player, World level, ItemStack stack) {
        return player.func_226563_dT_() && (stack.func_77973_b() == LocksmithItems.KEY.get() || stack.func_77973_b() == LocksmithItems.KEYRING.get()) && ((Key)stack.func_77973_b()).matchesLock(this.getId(), stack);
    }

    @Override
    public boolean canUnlock(PlayerEntity player, World level, ItemStack stack) {
        return player.func_184812_l_() || (stack.func_77973_b() == LocksmithItems.KEY.get() || stack.func_77973_b() == LocksmithItems.KEYRING.get()) && ((Key)stack.func_77973_b()).matchesLock(this.getId(), stack);
    }

    @Override
    public boolean pick(PlayerEntity player, World level, final LockPosition pos, final ItemStack pickStack, final Hand hand) {
        if (pickStack.func_77973_b() != LocksmithItems.LOCKPICK.get()) {
            return false;
        }
        if (!level.func_201670_d()) {
            player.func_213829_a(new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return LOCK_PICKING;
                }

                public Container createMenu(int containerId, PlayerInventory inventory, PlayerEntity player) {
                    return new LockpickingMenu(containerId, LockPickingContext.server(KeyLock.this.getPos(), pos.blockPosition(), (ServerPlayerEntity)player, pickStack, hand));
                }
            });
        }
        return true;
    }

    @Override
    public boolean onRightClick(PlayerEntity player, World level, ItemStack stack, BlockRayTraceResult hitResult) {
        if (this.canUnlock(player, level, stack)) {
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
            return true;
        }
        return false;
    }

    @Override
    public boolean onLeftClick(PlayerEntity player, World level, Hand hand, BlockPos pos, Direction direction) {
        return (Boolean)Locksmith.CONFIG.allowLocksToBeBroken.get();
    }

    @Override
    public boolean onRightClick(PlayerEntity player, World level, ItemStack stack, Entity entity) {
        if (this.canUnlock(player, level, stack)) {
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
            return true;
        }
        return false;
    }

    @Override
    public boolean onLeftClick(PlayerEntity player, World level, Hand hand, Entity entity) {
        return false;
    }
}

