/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lockpicking;

import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.network.LocksmithMessages;
import gg.moonflower.locksmith.common.network.play.ClientboundLockPickingPacket;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import gg.moonflower.locksmith.core.registry.LocksmithStats;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class ServerPickingContext
extends LockPickingContext {
    public static final int FAIL_WAIT_TIME = 10;
    public static final int FAIL_THRESHOLD = 10;
    protected final ServerPlayerEntity player;
    protected final ItemStack pickStack;
    protected final Hand pickHand;
    protected final Game game;
    protected int lastSetTime;
    protected LockPickingContext.GameState state;
    protected int stop;

    protected ServerPickingContext(ServerPlayerEntity player, ItemStack pickStack, Hand pickHand) {
        this.player = player;
        this.pickStack = pickStack;
        this.pickHand = pickHand;
        Random random = player.field_70170_p.func_201674_k();
        this.game = new Game(2, random);
        this.state = LockPickingContext.GameState.RUNNING;
        this.stop = 0;
        this.setPickDamage(pickStack.func_77952_i());
    }

    protected abstract void playSound(SoundEvent var1);

    protected abstract void removeLock();

    @Override
    public void pick(int pin) {
        if (this.getPinState(pin)) {
            LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(pin, true));
            return;
        }
        if (this.game.shouldDrop(pin)) {
            this.playSound(LocksmithSounds.LOCK_PICKING_SET.get());
            this.setPinState(pin, true);
            this.game.next(this);
            if (this.areAllPinsSet()) {
                this.stop(true);
            }
        } else {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.game.reset();
        this.playSound(LocksmithSounds.LOCK_PICKING_PINS_DROP.get());
        this.pickStack.func_222118_a(1, (LivingEntity)this.player, contextPlayer -> {
            this.state = LockPickingContext.GameState.FAIL;
            this.stop = this.player.field_70173_aa;
            this.playSound(LocksmithSounds.LOCK_PICKING_FAIL.get());
            LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.FAIL));
            contextPlayer.func_213334_d(this.pickHand);
        });
        this.setPickDamage(this.pickStack.func_190926_b() ? 2 : this.pickStack.func_77952_i());
        this.player.field_71069_bz.func_75142_b();
        super.reset();
        LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.RESET));
    }

    @Override
    public void stop(boolean success) {
        this.state = success ? LockPickingContext.GameState.SUCCESS : LockPickingContext.GameState.FAIL;
        this.stop = this.player.field_70173_aa;
        this.playSound(success ? LocksmithSounds.LOCK_PICKING_SUCCESS.get() : LocksmithSounds.LOCK_PICKING_FAIL.get());
        if (success) {
            LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.SUCCESS));
            this.player.func_195066_a(LocksmithStats.PICK_LOCK);
            this.removeLock();
            return;
        }
        this.pickStack.func_222118_a(1, (LivingEntity)this.player, contextPlayer -> contextPlayer.func_213334_d(this.pickHand));
        this.setPickDamage(this.pickStack.func_190926_b() ? 2 : this.pickStack.func_77952_i());
        LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.FAIL));
    }

    @Override
    public LockPickingContext.GameState getState() {
        return this.state;
    }

    @Override
    public void setPinState(int pin, boolean set) {
        if (pin < 0 || pin >= 5) {
            return;
        }
        super.setPinState(pin, set);
        if (this.player.field_70173_aa - this.lastSetTime < 10) {
            this.playSound(LocksmithSounds.LOCK_PICKING_OVERSET.get());
            this.stop(false);
            return;
        }
        this.lastSetTime = this.player.field_70173_aa;
        LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(pin, set));
    }

    @Override
    public boolean stillValid(PlayerEntity player) {
        return this.player == player && (this.state == LockPickingContext.GameState.RUNNING || this.player.field_70173_aa - this.stop < 10);
    }

    public static class Game {
        private final int[] droppingPins;
        private int droppingIndex;

        private Game(int complexity, Random random) {
            int size = MathHelper.func_76125_a((int)complexity, (int)0, (int)4);
            ArrayList<Integer> pins = new ArrayList<Integer>(size);
            while (pins.size() < size) {
                pins.add(random.nextInt(5));
            }
            this.droppingPins = pins.stream().mapToInt(Integer::intValue).toArray();
            this.droppingIndex = -1;
        }

        private boolean isNonDropping(int pin) {
            return IntStream.of(this.droppingPins).noneMatch(dropping -> dropping == pin);
        }

        public void reset() {
            this.droppingIndex = -1;
        }

        public void next(LockPickingContext context) {
            if (this.droppingIndex >= 0) {
                ++this.droppingIndex;
            } else {
                for (int i = 0; i < 5; ++i) {
                    if (!this.isNonDropping(i) || context.getPinState(i)) continue;
                    return;
                }
                this.droppingIndex = 0;
            }
        }

        public boolean shouldDrop(int pin) {
            return this.droppingIndex == -1 ? this.isNonDropping(pin) : this.droppingPins[this.droppingIndex] == pin;
        }
    }
}

