/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.menu;

import com.mojang.datafixers.util.Pair;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.menu.LocksmithResultContainer;
import gg.moonflower.locksmith.common.recipe.LocksmithingRecipe;
import gg.moonflower.locksmith.core.registry.LocksmithBlocks;
import gg.moonflower.locksmith.core.registry.LocksmithMenus;
import gg.moonflower.locksmith.core.registry.LocksmithRecipes;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import gg.moonflower.pollen.api.util.QuickMoveHelper;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class LocksmithingTableMenu
extends Container {
    public static final ResourceLocation EMPTY_SLOT_KEY = new ResourceLocation("locksmith", "item/empty_locksmithing_table_slot_key");
    private static final QuickMoveHelper MOVE_HELPER = new QuickMoveHelper().add(0, 4, 4, 36, true).add(4, 36, 0, 2, false);
    private final IWorldPosCallable access;
    private final PlayerEntity player;
    private final CraftingInventory craftSlots;
    private final LocksmithResultContainer resultSlots = new LocksmithResultContainer(2);
    private final Slot keyInputSlot;
    private final Slot inputSlot;
    private long lastSoundTime;
    private boolean partialTake;
    private boolean pendingTake;

    public LocksmithingTableMenu(int containerId, PlayerInventory inventory) {
        this(containerId, inventory, IWorldPosCallable.field_221489_a);
    }

    public LocksmithingTableMenu(int containerId, PlayerInventory inventory, IWorldPosCallable access) {
        super(LocksmithMenus.LOCKSMITHING_TABLE_MENU.get(), containerId);
        this.player = inventory.field_70458_d;
        this.access = access;
        this.craftSlots = new CraftingInventory((Container)this, 1, 2);
        this.keyInputSlot = this.func_75146_a(new Slot((IInventory)this.craftSlots, 0, 21, 17){

            public boolean func_75214_a(ItemStack stack) {
                return KeyItem.isKey(stack) || KeyItem.isBlankKey(stack);
            }

            public int func_75219_a() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_SLOT_KEY);
            }
        });
        this.inputSlot = this.func_75146_a(new Slot((IInventory)this.craftSlots, 1, 21, 54));
        this.func_75146_a(new LocksmithingResultSlot(0, 101, 35));
        this.func_75146_a(new LocksmithingResultSlot(1, 131, 35));
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.func_75146_a(new Slot((IInventory)inventory, y + x * 9 + 9, 8 + y * 18, 84 + x * 18));
            }
        }
        for (int hotbarIndex = 0; hotbarIndex < 9; ++hotbarIndex) {
            this.func_75146_a(new Slot((IInventory)inventory, hotbarIndex, 8 + hotbarIndex * 18, 142));
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return LocksmithingTableMenu.func_216963_a((IWorldPosCallable)this.access, (PlayerEntity)player, (Block)LocksmithBlocks.LOCKSMITHING_TABLE.get());
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.access.func_221486_a((level, blockPos) -> this.func_193327_a(player, (World)level, (IInventory)this.craftSlots));
        if (this.pendingTake) {
            this.access.func_221486_a((level, blockPos) -> this.func_193327_a(player, (World)level, this.resultSlots));
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int slot) {
        return MOVE_HELPER.quickMoveStack((Container)this, player, slot);
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        this.partialTake = this.resultSlots.func_70301_a(0).func_190926_b() ^ this.resultSlots.func_70301_a(1).func_190926_b();
        if (this.resultSlots.func_193055_i() != null && ((LocksmithingRecipe)this.resultSlots.func_193055_i()).getSecondResultItem().func_190926_b()) {
            this.partialTake = false;
        }
        if (inventory == this.craftSlots) {
            this.createResult();
        }
    }

    public CraftingInventory getCraftSlots() {
        return this.craftSlots;
    }

    protected static void slotChangedCraftingGrid(int containerId, World level, PlayerEntity player, CraftingInventory container, LocksmithResultContainer resultContainer) {
        if (!level.func_201670_d()) {
            LocksmithingRecipe recipe;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            ItemStack leftResult = ItemStack.field_190927_a;
            ItemStack rightResult = ItemStack.field_190927_a;
            Optional optional = level.func_73046_m().func_199529_aN().func_215371_a(LocksmithRecipes.LOCKSMITHING_TYPE.get(), (IInventory)container, level);
            if (optional.isPresent() && resultContainer.func_201561_a(level, serverPlayer, recipe = (LocksmithingRecipe)optional.get())) {
                leftResult = recipe.func_77572_b((IInventory)container);
                rightResult = recipe.getSecondAssembledResult();
            }
            resultContainer.func_70299_a(0, leftResult);
            resultContainer.func_70299_a(1, rightResult);
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(containerId, 2, leftResult));
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(containerId, 3, rightResult));
        }
    }

    private void createResult() {
        if (this.partialTake) {
            return;
        }
        if (this.pendingTake && !this.resultSlots.func_191420_l()) {
            return;
        }
        this.resultSlots.func_70299_a(0, ItemStack.field_190927_a);
        this.resultSlots.func_70299_a(1, ItemStack.field_190927_a);
        this.pendingTake = false;
        this.access.func_221486_a((level, blockPos) -> LocksmithingTableMenu.slotChangedCraftingGrid(this.field_75152_c, level, this.player, this.craftSlots, this.resultSlots));
    }

    class LocksmithingResultSlot
    extends Slot {
        private int removeCount;

        public LocksmithingResultSlot(int index, int x, int y) {
            super((IInventory)LocksmithingTableMenu.this.resultSlots, index, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_75209_a(int amount) {
            if (this.func_75216_d()) {
                this.removeCount += Math.min(amount, this.func_75211_c().func_190916_E());
            }
            return super.func_75209_a(amount);
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            if (LocksmithingTableMenu.this.pendingTake) {
                if (LocksmithingTableMenu.this.resultSlots.func_191420_l()) {
                    this.func_75218_e();
                    LocksmithingTableMenu.this.pendingTake = false;
                    if (!player.field_70170_p.func_201670_d()) {
                        LocksmithingTableMenu.this.func_75130_a((IInventory)LocksmithingTableMenu.this.craftSlots);
                    }
                }
                return stack;
            }
            if (LocksmithingTableMenu.this.resultSlots.func_70301_a(0).func_190926_b() ^ LocksmithingTableMenu.this.resultSlots.func_70301_a(1).func_190926_b()) {
                LocksmithingTableMenu.this.pendingTake = true;
            }
            LocksmithingTableMenu.this.keyInputSlot.func_75209_a(1);
            LocksmithingTableMenu.this.inputSlot.func_75209_a(1);
            this.func_75208_c(stack);
            super.func_190901_a(player, stack);
            LocksmithingTableMenu.this.access.func_221486_a((level, pos) -> {
                long l = level.func_82737_E();
                if (LocksmithingTableMenu.this.lastSoundTime != l) {
                    level.func_184133_a(null, pos, LocksmithSounds.UI_LOCKSMITHING_TABLE_TAKE_RESULT.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    LocksmithingTableMenu.this.lastSoundTime = l;
                }
            });
            return stack;
        }

        protected void func_75210_a(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.func_75208_c(stack);
        }

        protected void func_75208_c(ItemStack stack) {
            if (this.removeCount > 0) {
                stack.func_77980_a(((LocksmithingTableMenu)LocksmithingTableMenu.this).player.field_70170_p, LocksmithingTableMenu.this.player, this.removeCount);
            }
            if (this.field_75224_c instanceof IRecipeHolder) {
                ((IRecipeHolder)this.field_75224_c).func_201560_d(LocksmithingTableMenu.this.player);
            }
            this.removeCount = 0;
        }
    }
}

