/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.network.play.handler;

import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.BlockLockPosition;
import gg.moonflower.locksmith.api.lock.position.EntityLockPosition;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.client.lock.ClientLockManager;
import gg.moonflower.locksmith.client.screen.LockPickingScreen;
import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.menu.LockpickingMenu;
import gg.moonflower.locksmith.common.network.play.ClientboundAddLocksPacket;
import gg.moonflower.locksmith.common.network.play.ClientboundDeleteLocksPacket;
import gg.moonflower.locksmith.common.network.play.ClientboundLockPickingPacket;
import gg.moonflower.locksmith.common.network.play.handler.LocksmithClientPlayPacketHandler;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class LocksmithClientPlayPacketHandlerImpl
implements LocksmithClientPlayPacketHandler {
    private Entity getLockEntity(ClientWorld level, EntityLockPosition pos) {
        UUID id = pos.getEntityId();
        for (Entity e : level.func_217416_b()) {
            if (!e.func_110124_au().equals(id)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void handleAddLocks(ClientboundAddLocksPacket msg, PollinatedPacketContext ctx) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return;
        }
        LockManager manager = LockManager.get((World)level);
        ctx.enqueueWork(() -> {
            if (msg.isReplace()) {
                msg.getLocks().stream().filter(lock -> lock.getPos() instanceof BlockLockPosition).map(lock -> new ChunkPos(lock.getPos().blockPosition())).distinct().forEach(chunk -> ((ClientLockManager)manager).clearLocks((ChunkPos)chunk));
            }
            for (AbstractLock lock2 : msg.getLocks()) {
                if (lock2.getPos() instanceof EntityLockPosition) {
                    EntityLockPosition entityLockPos = (EntityLockPosition)lock2.getPos();
                    entityLockPos.setEntity(() -> this.getLockEntity(level, entityLockPos));
                }
                manager.addLock(lock2);
            }
        });
    }

    @Override
    public void handleDeleteLock(ClientboundDeleteLocksPacket msg, PollinatedPacketContext ctx) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return;
        }
        for (LockPosition pos : msg.getPositions()) {
            Entity e;
            if (pos instanceof BlockLockPosition) {
                ctx.enqueueWork(() -> LockManager.get((World)level).removeLock(pos.blockPosition()));
                continue;
            }
            if (!(pos instanceof EntityLockPosition) || (e = this.getLockEntity(level, (EntityLockPosition)pos)) == null) continue;
            ctx.enqueueWork(() -> LockManager.get((World)level).removeLock(e));
        }
    }

    @Override
    public void handleLockPicking(ClientboundLockPickingPacket msg, PollinatedPacketContext ctx) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof LockPickingScreen)) {
            return;
        }
        LockPickingContext context = ((LockpickingMenu)((LockPickingScreen)screen).func_212873_a_()).getContext();
        ctx.enqueueWork(() -> {
            switch (msg.getType()) {
                case SET: {
                    context.setPinState(msg.getPin(), msg.isSet());
                    ((LockPickingScreen)screen).lowerPick();
                    break;
                }
                case RESET: {
                    context.reset();
                    ((LockPickingScreen)screen).lowerPick();
                    break;
                }
                case SUCCESS: {
                    context.stop(true);
                    break;
                }
                case FAIL: {
                    context.stop(false);
                }
            }
        });
    }
}

