/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.recipe;

import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.item.LockItem;
import gg.moonflower.locksmith.common.recipe.forge.LocksmithingRecipeImpl;
import gg.moonflower.locksmith.core.registry.LocksmithBlocks;
import gg.moonflower.locksmith.core.registry.LocksmithRecipes;
import java.util.UUID;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class LocksmithingRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient topInput;
    private final Ingredient bottomInput;
    private final ItemStack leftResult;
    private final ItemStack rightResult;
    private ItemStack rightAssembledResult;

    public LocksmithingRecipe(ResourceLocation id, String group, Ingredient topInput, Ingredient bottomInput, ItemStack leftResult, ItemStack rightResult) {
        this.id = id;
        this.group = group;
        this.topInput = topInput;
        this.bottomInput = bottomInput;
        this.leftResult = leftResult;
        this.rightResult = rightResult;
    }

    public boolean func_77569_a(IInventory container, World level) {
        ItemStack topInput = container.func_70301_a(0);
        ItemStack bottomInput = container.func_70301_a(1);
        if (!this.topInput.test(topInput) || !this.bottomInput.test(bottomInput)) {
            return false;
        }
        if (KeyItem.isKey(topInput) && KeyItem.isKey(bottomInput) && !KeyItem.isOriginal(topInput)) {
            return false;
        }
        return !(KeyItem.canHaveLock(topInput) && !KeyItem.hasLockId(topInput) || KeyItem.canHaveLock(bottomInput) && !KeyItem.hasLockId(bottomInput));
    }

    public ItemStack func_77572_b(IInventory container) {
        ItemStack topInput = container.func_70301_a(0);
        ItemStack bottomInput = container.func_70301_a(1);
        ItemStack leftResult = this.leftResult.func_77946_l();
        ItemStack rightResult = this.rightResult.func_77946_l();
        if (topInput.func_82837_s()) {
            leftResult.func_200302_a(topInput.func_200301_q());
        }
        if (bottomInput.func_82837_s()) {
            rightResult.func_200302_a(bottomInput.func_200301_q());
        } else if (topInput.func_82837_s() && (KeyItem.isKey(topInput) || KeyItem.isBlankKey(topInput)) && (KeyItem.isKey(bottomInput) || KeyItem.isBlankKey(bottomInput))) {
            rightResult.func_200302_a(topInput.func_200301_q());
        }
        if (KeyItem.isKey(topInput) || KeyItem.isBlankKey(topInput)) {
            UUID lockId;
            UUID uUID = lockId = KeyItem.hasLockId(topInput) ? KeyItem.getLockId(topInput) : UUID.randomUUID();
            if (KeyItem.canHaveLock(leftResult)) {
                KeyItem.setLockId(leftResult, lockId);
            }
            if (KeyItem.canHaveLock(rightResult)) {
                KeyItem.setLockId(rightResult, lockId);
            }
            if (KeyItem.isOriginal(topInput) || KeyItem.isBlankKey(topInput)) {
                KeyItem.setOriginal(leftResult, true);
            }
            if (topInput.func_82837_s()) {
                ITextComponent name = topInput.func_200301_q();
                LockItem.setKeyName(leftResult, name);
                LockItem.setKeyName(rightResult, name);
            }
        }
        this.rightAssembledResult = rightResult;
        return leftResult;
    }

    public ItemStack getSecondAssembledResult() {
        if (this.rightAssembledResult == null) {
            throw new IllegalStateException("LocksmithingRecipe#assemble() must be called before LocksmithingRecipe#getSecondAssembledResult()");
        }
        ItemStack result = this.rightAssembledResult.func_77946_l();
        this.rightAssembledResult = null;
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 1 && height >= 2;
    }

    public Ingredient getTopInput() {
        return this.topInput;
    }

    public Ingredient getBottomInput() {
        return this.bottomInput;
    }

    public ItemStack func_77571_b() {
        return this.leftResult;
    }

    public ItemStack getSecondResultItem() {
        return this.rightResult;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.topInput, this.bottomInput});
    }

    public String func_193358_e() {
        return this.group;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)LocksmithBlocks.LOCKSMITHING_TABLE.get());
    }

    public IRecipeSerializer<?> func_199559_b() {
        return LocksmithRecipes.LOCKSMITHING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return LocksmithRecipes.LOCKSMITHING_TYPE.get();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IRecipeSerializer<LocksmithingRecipe> createSerializer() {
        return LocksmithingRecipeImpl.createSerializer();
    }
}

