/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.recipe.forge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.locksmith.common.recipe.LocksmithingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LocksmithingRecipeImpl
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<LocksmithingRecipe> {
    public static IRecipeSerializer<LocksmithingRecipe> createSerializer() {
        return new LocksmithingRecipeImpl();
    }

    public LocksmithingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        Ingredient topInput = Ingredient.func_199802_a((JsonElement)json.get("topInput"));
        Ingredient bottomInput = Ingredient.func_199802_a((JsonElement)json.get("bottomInput"));
        boolean singleResult = json.has("result");
        if (singleResult && (json.has("leftResult") || json.has("rightResult"))) {
            throw new JsonSyntaxException("'result' is not compatible with either 'leftResult' or 'rightResult'");
        }
        ItemStack leftResult = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)(singleResult ? "result" : "leftResult")));
        ItemStack rightResult = singleResult ? ItemStack.field_190927_a : ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"rightResult"));
        return new LocksmithingRecipe(recipeId, group, topInput, bottomInput, leftResult, rightResult);
    }

    public LocksmithingRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buf) {
        String group = buf.func_218666_n();
        Ingredient topInput = Ingredient.func_199566_b((PacketBuffer)buf);
        Ingredient bottomInput = Ingredient.func_199566_b((PacketBuffer)buf);
        ItemStack leftResult = buf.func_150791_c();
        ItemStack rightResult = buf.func_150791_c();
        return new LocksmithingRecipe(recipeId, group, topInput, bottomInput, leftResult, rightResult);
    }

    public void toNetwork(PacketBuffer buf, LocksmithingRecipe recipe) {
        buf.func_180714_a(recipe.func_193358_e());
        recipe.getTopInput().func_199564_a(buf);
        recipe.getBottomInput().func_199564_a(buf);
        buf.func_150788_a(recipe.func_77571_b());
        buf.func_150788_a(recipe.getSecondResultItem());
    }
}

