/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.core.forge.compat.jei;

import com.google.common.collect.ImmutableList;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.recipe.LocksmithingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LocksmithingJeiRecipe {
    private final List<List<ItemStack>> inputs;
    private final List<List<ItemStack>> outputs;

    public LocksmithingJeiRecipe(LocksmithingRecipe recipe) {
        Inventory container = new Inventory(2);
        List input1 = Arrays.stream(recipe.getTopInput().func_193365_a()).peek(stack -> {
            KeyItem.setLockId(stack, Util.field_240973_b_);
            if (KeyItem.isKey(stack) && !KeyItem.isOriginal(stack)) {
                KeyItem.setOriginal(stack, true);
            }
        }).collect(Collectors.toList());
        List<ItemStack> input2 = Arrays.asList(recipe.getBottomInput().func_193365_a());
        ArrayList<ItemStack> output1 = new ArrayList<ItemStack>();
        ArrayList<ItemStack> output2 = new ArrayList<ItemStack>();
        for (ItemStack topInput : recipe.getTopInput().func_193365_a()) {
            ItemStack topInputCopy = topInput.func_77946_l();
            if (KeyItem.isKey(topInputCopy) && !KeyItem.isOriginal(topInputCopy)) {
                KeyItem.setOriginal(topInputCopy, true);
            }
            container.func_70299_a(0, topInputCopy);
            for (ItemStack bottomInput : recipe.getTopInput().func_193365_a()) {
                container.func_70299_a(1, bottomInput);
                ItemStack stack1 = recipe.func_77572_b((IInventory)container);
                ItemStack stack2 = recipe.getSecondResultItem();
                KeyItem.setLockId(stack1, Util.field_240973_b_);
                if (output1.stream().noneMatch(s -> ItemStack.func_77989_b((ItemStack)s, (ItemStack)stack1))) {
                    output1.add(stack1);
                }
                if (stack2.func_190926_b()) continue;
                KeyItem.setLockId(stack2, Util.field_240973_b_);
                if (!output1.stream().noneMatch(s -> ItemStack.func_77989_b((ItemStack)s, (ItemStack)stack2))) continue;
                output2.add(stack2);
            }
        }
        this.inputs = ImmutableList.of(input1, input2);
        this.outputs = output2.isEmpty() ? ImmutableList.of(output1) : ImmutableList.of(output1, output2);
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public List<List<ItemStack>> getOutputs() {
        return this.outputs;
    }
}

