/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.api.lock;

import com.mojang.serialization.Codec;
import gg.moonflower.locksmith.api.lock.LockType;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.core.registry.LocksmithLocks;
import gg.moonflower.locksmith.core.registry.LocksmithParticles;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;

public abstract class AbstractLock {
    public static final Codec<AbstractLock> CODEC = LocksmithLocks.LOCKS.dispatch(AbstractLock::getType, LockType::codec);
    private final LockType type;
    private final UUID id;
    private final LockPosition pos;
    private final ItemStack stack;

    public AbstractLock(LockType type, UUID id, LockPosition pos, ItemStack stack) {
        this.type = type;
        this.id = id;
        this.pos = pos;
        this.stack = stack;
    }

    public UUID getId() {
        return this.id;
    }

    public LockPosition getPos() {
        return this.pos;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public LockType getType() {
        return this.type;
    }

    public void onRemove(Level level, BlockPos pos, BlockPos clickPos) {
        level.m_8055_(clickPos).m_60771_((BlockGetter)level, pos, CollisionContext.m_82749_()).m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double d1 = Math.min(1.0, maxX - minX);
            double d2 = Math.min(1.0, maxY - minY);
            double d3 = Math.min(1.0, maxZ - minZ);
            int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.4)));
            int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.4)));
            int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.4)));
            ((ServerLevel)level).m_8767_((ParticleOptions)LocksmithParticles.LOCK_BREAK.get(), (double)pos.m_123341_() + minX + maxX / 2.0, (double)pos.m_123342_() + minY + maxY / 2.0, (double)pos.m_123343_() + minZ + maxZ / 2.0, i * j * k, (maxX - minX) / 4.0 + 0.0625, (maxY - minY) / 4.0 + 0.0625, (maxZ - minZ) / 4.0 + 0.0625, 0.0);
        });
    }

    public void onRemove(Entity entity) {
        double d1 = Math.min(1.0, (double)entity.m_20205_());
        double d2 = Math.min(1.0, (double)entity.m_20206_());
        double d3 = Math.min(1.0, (double)entity.m_20205_());
        int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.4)));
        int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.4)));
        int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.4)));
        ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)LocksmithParticles.LOCK_BREAK.get(), entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), i * j * k, (double)entity.m_20205_() / 4.0 + 0.0625, (double)entity.m_20206_() / 4.0 + 0.0625, (double)entity.m_20205_() / 4.0 + 0.0625, 0.0);
    }

    public abstract boolean canRemove(Player var1, Level var2, ItemStack var3);

    public abstract boolean pick(Player var1, Level var2, LockPosition var3, ItemStack var4, InteractionHand var5);

    public abstract boolean canUnlock(Player var1, Level var2, ItemStack var3);

    public abstract boolean onRightClick(Player var1, Level var2, ItemStack var3, BlockHitResult var4);

    public abstract boolean onLeftClick(Player var1, Level var2, InteractionHand var3, BlockPos var4, Direction var5);

    public abstract boolean onRightClick(Player var1, Level var2, ItemStack var3, Entity var4);

    public abstract boolean onLeftClick(Player var1, Level var2, InteractionHand var3, Entity var4);
}

