/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.menu.LockpickingMenu;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import gg.moonflower.pollen.api.client.render.ShapeRenderer;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class LockPickingScreen
extends AbstractContainerScreen<LockpickingMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("locksmith", "textures/gui/lockpicking.png");
    private static final float MOVE_SPEED = 0.8f;
    private final LockPickingContext context;
    private float lastPickIndex;
    private int pickIndex;
    private boolean raised;
    private boolean deferRaised;
    private float lastPickProgress;
    private float pickProgress;

    public LockPickingScreen(LockpickingMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.context = menu.getContext();
        this.f_97726_ = 104;
        this.f_97727_ = 34;
    }

    public void lowerPick() {
        this.raised = false;
    }

    public void m_181908_() {
        this.lastPickProgress = this.pickProgress;
        if (this.context.getState() != LockPickingContext.GameState.RUNNING) {
            return;
        }
        if (this.pickProgress < 1.0f) {
            this.pickProgress += 0.8f;
            if (this.pickProgress > 1.0f) {
                this.pickProgress = 1.0f;
            }
            if (this.pickProgress >= 1.0f && this.deferRaised) {
                this.deferRaised = false;
                this.context.pick(this.pickIndex);
            }
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        int selectedIndex;
        partialTicks = this.f_96541_.m_91296_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        VertexConsumer builder = ShapeRenderer.begin();
        ShapeRenderer.drawRectWithTexture((VertexConsumer)builder, (PoseStack)matrixStack, (float)this.f_97735_, (float)this.f_97736_, (float)0.0f, (float)0.0f, (float)this.f_97726_, (float)this.f_97727_, (float)this.f_97726_, (float)this.f_97727_, (float)128.0f, (float)128.0f);
        for (int i = 0; i < 5; ++i) {
            ShapeRenderer.drawRectWithTexture((VertexConsumer)builder, (PoseStack)matrixStack, (float)(this.f_97735_ + i * 18 + 10), (float)(this.f_97736_ + this.f_97727_ - 3), (float)(104 + (this.context.getPinState(i) ? 12 : 0)), (float)0.0f, (float)12.0f, (float)10.0f, (float)12.0f, (float)10.0f, (float)128.0f, (float)128.0f);
        }
        if (this.context.getState() == LockPickingContext.GameState.RUNNING && (selectedIndex = (mouseX - this.f_97735_ - 11) / 18) >= 0 && selectedIndex < 5 && this.m_6774_(12 + selectedIndex * 18, 32, 8, 10, mouseX, mouseY)) {
            ShapeRenderer.drawRectWithTexture((VertexConsumer)builder, (PoseStack)matrixStack, (float)(this.f_97735_ + selectedIndex * 18 + 10), (float)(this.f_97736_ + this.f_97727_ - 3), (float)(104 + (this.context.getPinState(selectedIndex) ? 12 : 0)), (float)10.0f, (float)12.0f, (float)10.0f, (float)12.0f, (float)10.0f, (float)128.0f, (float)128.0f);
        }
        float x = this.getRenderPickIndex(partialTicks) * 18.0f - 27.0f;
        float y = !(this.getPickProgress(partialTicks) != 1.0f && this.context.getPinState((int)this.lastPickIndex) != this.context.getPinState(this.pickIndex) || !this.raised && !this.context.getPinState(this.pickIndex)) ? -2.0f : 0.0f;
        ShapeRenderer.drawRectWithTexture((VertexConsumer)builder, (PoseStack)matrixStack, (float)(this.f_97735_ + (int)x), (float)(this.f_97736_ + this.f_97727_ + (int)y + 7), (float)0.0f, (float)(34 + this.context.getPickDamage() * 18), (float)46.0f, (float)18.0f, (float)46.0f, (float)18.0f, (float)128.0f, (float)128.0f);
        ShapeRenderer.end();
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int selectedIndex;
        if (button == 0 && this.context.getState() == LockPickingContext.GameState.RUNNING && !this.raised && (selectedIndex = (int)((mouseX - (double)this.f_97735_ - 11.0) / 18.0)) >= 0 && selectedIndex < 5 && this.m_6774_(12 + selectedIndex * 18, 32, 8, 10, mouseX, mouseY)) {
            this.lastPickIndex = this.getRenderPickIndex(1.0f);
            this.lastPickProgress = 0.0f;
            this.pickProgress = 0.0f;
            this.pickIndex = selectedIndex;
            if (!this.context.getPinState(this.pickIndex)) {
                this.raised = true;
                if (this.pickProgress == 1.0f) {
                    this.context.pick(this.pickIndex);
                } else {
                    this.deferRaised = true;
                }
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.context.getState() == LockPickingContext.GameState.RUNNING && !this.raised) {
            if (keyCode == 65 || keyCode == 263) {
                if (this.pickIndex < 1) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)LocksmithSounds.LOCK_PICKING_TOO_NEAR.get(), (float)1.0f));
                    return true;
                }
                this.lastPickIndex = this.getRenderPickIndex(1.0f);
                this.lastPickProgress = 0.0f;
                this.pickProgress = 0.0f;
                --this.pickIndex;
                return true;
            }
            if (keyCode == 68 || keyCode == 262) {
                if (this.pickIndex >= 4) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)LocksmithSounds.LOCK_PICKING_TOO_FAR.get(), (float)1.0f));
                    return true;
                }
                this.lastPickIndex = this.getRenderPickIndex(1.0f);
                this.lastPickProgress = 0.0f;
                this.pickProgress = 0.0f;
                ++this.pickIndex;
                return true;
            }
            if (keyCode == 32 && !this.context.getPinState(this.pickIndex)) {
                this.raised = true;
                if (this.pickProgress == 1.0f) {
                    this.context.pick(this.pickIndex);
                } else {
                    this.deferRaised = true;
                }
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private float getPickProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lastPickProgress, (float)this.pickProgress);
    }

    private float getRenderPickIndex(float partialTicks) {
        return Mth.m_14179_((float)this.getPickProgress(partialTicks), (float)this.lastPickIndex, (float)this.pickIndex);
    }
}

