/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.client.tooltip;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import gg.moonflower.locksmith.common.tooltip.KeyringTooltip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ClientKeyringTooltip
implements ClientTooltipComponent {
    private static final int PADDING = 2;
    private final KeyringTooltip tooltip;
    private final List<Component> tooltipList;

    public ClientKeyringTooltip(KeyringTooltip tooltip) {
        this.tooltip = tooltip;
        this.tooltipList = new ArrayList<Component>();
    }

    public int m_142103_() {
        List<ItemStack> stacks = this.tooltip.getItems();
        int y = 0;
        for (ItemStack stack : stacks) {
            this.updateTooltip(stack);
            y += Math.max(this.tooltipList.size() * 11, 18);
        }
        return y + Math.max(0, stacks.size() - 1) * 2;
    }

    public int m_142069_(Font font) {
        return 20 + this.tooltip.getItems().stream().flatMapToInt(stack -> {
            this.updateTooltip((ItemStack)stack);
            return this.tooltipList.stream().mapToInt(arg_0 -> ((Font)font).m_92852_(arg_0));
        }).max().orElse(0);
    }

    public void m_142440_(Font font, int x, int y, Matrix4f matrix4f, MultiBufferSource.BufferSource bufferSource) {
        List<ItemStack> stacks = this.tooltip.getItems();
        for (ItemStack stack : stacks) {
            this.updateTooltip(stack);
            for (int i = 0; i < this.tooltipList.size(); ++i) {
                font.m_92841_(this.tooltipList.get(i), (float)(x + 18 + 2), (float)(y + i * 11), -1, true, matrix4f, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
            }
            y += Math.max(this.tooltipList.size() * 11 + 2, 20);
        }
    }

    public void m_183452_(Font font, int x, int y, PoseStack poseStack, ItemRenderer itemRenderer, int z) {
        List<ItemStack> stacks = this.tooltip.getItems();
        for (ItemStack stack : stacks) {
            this.updateTooltip(stack);
            itemRenderer.m_174253_(stack, x, y, z);
            itemRenderer.m_115169_(font, stack, x, y);
            y += Math.max(this.tooltipList.size() * 11 + 2, 20);
        }
    }

    private void updateTooltip(ItemStack stack) {
        this.tooltipList.clear();
        MutableComponent name = new TextComponent("").m_7220_(stack.m_41786_()).m_130940_(stack.m_41791_().f_43022_);
        if (stack.m_41788_()) {
            name.m_130940_(ChatFormatting.ITALIC);
        }
        this.tooltipList.add((Component)name);
        stack.m_41720_().m_7373_(stack, (Level)Minecraft.m_91087_().f_91073_, this.tooltipList, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }
}

