/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.item;

import gg.moonflower.locksmith.api.key.Key;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.item.KeyringItem;
import gg.moonflower.locksmith.core.Locksmith;
import gg.moonflower.locksmith.core.registry.LocksmithItems;
import gg.moonflower.locksmith.core.registry.LocksmithTags;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KeyItem
extends Item
implements Key {
    private static final Component ORIGINAL = new TranslatableComponent("item.locksmith.key.original").m_130940_(ChatFormatting.GRAY);
    private static final Component COPY = new TranslatableComponent("item.locksmith.key.copy").m_130940_(ChatFormatting.GRAY);

    public KeyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        AbstractLock abstractLock = LockManager.get(level).getLock(LockPosition.of(pos));
        if (player == null || abstractLock == null) {
            return InteractionResult.PASS;
        }
        if (abstractLock.canRemove(player, level, context.m_43722_())) {
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            LockManager.get(level).removeLock(abstractLock.getPos().blockPosition(), pos, true);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean m_142207_(ItemStack key, Slot slot, ClickAction clickAction, Player player) {
        if (((Boolean)Locksmith.CONFIG.useKeyringMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        return KeyItem.addKeyring(key, slot.m_7993_(), slot, player);
    }

    public boolean m_142305_(ItemStack key, ItemStack clickItem, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (((Boolean)Locksmith.CONFIG.useKeyringMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction == ClickAction.SECONDARY && slot.m_150651_(player)) {
            return KeyItem.addKeyring(key, clickItem, slot, player);
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (level != null) {
            tooltipComponents.add(KeyItem.isOriginal(stack) ? ORIGINAL : COPY);
        }
        if (isAdvanced.m_7050_()) {
            UUID id = KeyItem.getLockId(stack);
            if (id == null || Util.f_137441_.equals(id)) {
                return;
            }
            tooltipComponents.add((Component)new TextComponent("Lock Id: " + id).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    private static boolean addKeyring(ItemStack key, ItemStack clickItem, Slot slot, Player player) {
        if (clickItem.m_41619_()) {
            return false;
        }
        if (!clickItem.m_150930_(LocksmithItems.KEY.get())) {
            return false;
        }
        player.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
        ItemStack keyring = new ItemStack((ItemLike)LocksmithItems.KEYRING.get());
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (((ItemStack)player.m_150109_().f_35974_.get(i)).m_41619_() || slot.m_7993_() != player.m_150109_().f_35974_.get(i)) continue;
            KeyringItem.setKeys(keyring, Arrays.asList(key.m_41620_(1), slot.m_150647_(clickItem.m_41613_(), 1, player)));
            player.m_150109_().m_6836_(i, keyring);
            return true;
        }
        KeyringItem.setKeys(keyring, Arrays.asList(key.m_41620_(1), slot.m_150647_(clickItem.m_41613_(), 1, player)));
        player.m_150109_().m_150079_(keyring);
        return true;
    }

    @Override
    public boolean matchesLock(UUID id, ItemStack stack) {
        return id.equals(KeyItem.getLockId(stack));
    }

    public static boolean canHaveLock(ItemStack stack) {
        return stack.m_150922_(LocksmithTags.LOCKING);
    }

    public static boolean isKey(ItemStack stack) {
        return !stack.m_150922_(LocksmithTags.BLANK_KEY) && stack.m_41720_() instanceof Key;
    }

    public static boolean isBlankKey(ItemStack stack) {
        return stack.m_150922_(LocksmithTags.BLANK_KEY);
    }

    public static boolean hasLockId(ItemStack stack) {
        if (stack.m_41783_() == null || !KeyItem.canHaveLock(stack)) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag.m_128403_("Lock");
    }

    @Nullable
    public static UUID getLockId(ItemStack stack) {
        if (stack.m_41783_() == null || !KeyItem.canHaveLock(stack)) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        return tag.m_128403_("Lock") ? tag.m_128342_("Lock") : null;
    }

    public static void setLockId(ItemStack stack, @Nullable UUID id) {
        if (KeyItem.canHaveLock(stack)) {
            if (stack.m_41783_() == null && id == null) {
                return;
            }
            if (id == null) {
                stack.m_41783_().m_128473_("Lock");
                if (stack.m_41783_().m_128456_()) {
                    stack.m_41751_(null);
                }
                return;
            }
            stack.m_41784_().m_128362_("Lock", id);
        }
    }

    public static boolean isOriginal(ItemStack stack) {
        return KeyItem.isKey(stack) && KeyItem.hasLockId(stack) && stack.m_41784_().m_128471_("Original");
    }

    public static void setOriginal(ItemStack stack, boolean original) {
        if (KeyItem.isKey(stack) && KeyItem.hasLockId(stack)) {
            stack.m_41784_().m_128379_("Original", original);
        }
    }
}

