/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.item;

import gg.moonflower.locksmith.api.key.Key;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.menu.KeyringMenu;
import gg.moonflower.locksmith.common.tooltip.KeyringTooltip;
import gg.moonflower.locksmith.core.Locksmith;
import gg.moonflower.locksmith.core.registry.LocksmithItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class KeyringItem
extends Item
implements Key {
    public static final int MAX_KEYS = 4;

    public KeyringItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean matchesLock(UUID id, ItemStack stack) {
        for (ItemStack key : KeyringItem.getKeys(stack)) {
            if (!id.equals(KeyItem.getLockId(key))) continue;
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        final ItemStack stack = player.m_21120_(hand);
        if (!player.m_36341_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (((Boolean)Locksmith.CONFIG.useKeyringMenu.get()).booleanValue()) {
            final int index = player.m_150109_().m_36030_(stack);
            if (index == -1) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (!level.m_5776_()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                player.m_5893_(new MenuProvider(){

                    public Component m_5446_() {
                        return stack.m_41786_();
                    }

                    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
                        return new KeyringMenu(containerId, inventory, index);
                    }
                });
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        if (KeyringItem.dropContents(stack, player)) {
            this.playDropContentsSound((Entity)player);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)ItemStack.f_41583_, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public boolean m_142207_(ItemStack keyRing, Slot slot, ClickAction clickAction, Player player) {
        if (((Boolean)Locksmith.CONFIG.useKeyringMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack clickItem = slot.m_7993_();
        if (clickItem.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            KeyringItem.removeOne(player, keyRing).ifPresent(key -> KeyringItem.add(keyRing, slot.m_150659_(key)));
        } else if (KeyringItem.canAdd(keyRing, clickItem)) {
            this.playInsertSound((Entity)player);
            KeyringItem.add(keyRing, slot.m_150647_(clickItem.m_41613_(), 1, player));
        }
        return true;
    }

    public boolean m_142305_(ItemStack keyRing, ItemStack clickItem, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (((Boolean)Locksmith.CONFIG.useKeyringMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (clickItem.m_41619_()) {
                KeyringItem.removeOne(player, keyRing).ifPresent(removedKey -> {
                    this.playRemoveOneSound((Entity)player);
                    slotAccess.m_142104_(removedKey);
                });
            } else if (KeyringItem.canAdd(keyRing, clickItem)) {
                this.playInsertSound((Entity)player);
                KeyringItem.add(keyRing, clickItem);
            }
            return true;
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        AbstractLock lock = LockManager.get(level).getLock(LockPosition.of(pos));
        if (player == null || lock == null) {
            return InteractionResult.PASS;
        }
        for (ItemStack key : KeyringItem.getKeys(context.m_43722_())) {
            if (!lock.canRemove(player, level, key)) continue;
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            LockManager.get(level).removeLock(lock.getPos().blockPosition(), pos, true);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        return Optional.of(new KeyringTooltip(KeyringItem.getKeys(itemStack)));
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, KeyringItem.getKeys(itemEntity.m_32055_()).stream());
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    public static List<ItemStack> getKeys(ItemStack stack) {
        if (!stack.m_150930_(LocksmithItems.KEYRING.get())) {
            return Collections.emptyList();
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128425_("Keys", 9)) {
            return Collections.emptyList();
        }
        ListTag keysNbt = nbt.m_128437_("Keys", 10);
        if (keysNbt.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(keysNbt.size());
        for (int i = 0; i < Math.min(4, keysNbt.size()); ++i) {
            ItemStack key = ItemStack.m_41712_((CompoundTag)keysNbt.m_128728_(i));
            if (key.m_41619_()) continue;
            list.add(key);
        }
        return list;
    }

    public static void setKeys(ItemStack stack, Collection<ItemStack> keys) {
        if (!stack.m_150930_(LocksmithItems.KEYRING.get()) || keys.isEmpty()) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        ListTag keysNbt = new ListTag();
        int i = 0;
        for (ItemStack key : keys) {
            if (key.m_41619_()) continue;
            if (i >= 4) break;
            keysNbt.add((Object)key.m_41739_(new CompoundTag()));
            ++i;
        }
        nbt.m_128365_("Keys", (Tag)keysNbt);
    }

    private static Optional<ItemStack> removeOne(Player player, ItemStack keyRing) {
        CompoundTag tag = keyRing.m_41784_();
        if (!tag.m_128425_("Keys", 9)) {
            return Optional.empty();
        }
        ListTag keysNbt = tag.m_128437_("Keys", 10);
        if (keysNbt.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag keyNbt = keysNbt.m_128728_(0);
        ItemStack keyStack = ItemStack.m_41712_((CompoundTag)keyNbt);
        keysNbt.remove(0);
        if (keysNbt.size() == 1) {
            ItemStack last = ItemStack.m_41712_((CompoundTag)keysNbt.m_128728_(0));
            ItemStack carried = player.f_36095_.m_142621_();
            if (!carried.m_41619_() && carried == keyRing) {
                keyRing.m_41764_(0);
                player.f_36095_.m_142503_(last);
                return Optional.of(keyStack);
            }
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.f_35974_.size(); ++i) {
                if (((ItemStack)inventory.f_35974_.get(i)).m_41619_() || keyRing != inventory.f_35974_.get(i)) continue;
                keyRing.m_41764_(0);
                inventory.m_6836_(i, last);
                return Optional.of(keyStack);
            }
            inventory.m_150079_(last);
        }
        if (keysNbt.isEmpty()) {
            keyRing.m_41764_(0);
        }
        return Optional.of(keyStack);
    }

    private static boolean dropContents(ItemStack itemStack, Player player) {
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_("Keys")) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag listTag = tag.m_128437_("Keys", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                player.m_150109_().m_150079_(ItemStack.m_41712_((CompoundTag)listTag.m_128728_(i)));
            }
        }
        itemStack.m_41749_("Keys");
        return true;
    }

    private static void add(ItemStack keyRing, ItemStack key) {
        if (!keyRing.m_150930_(LocksmithItems.KEYRING.get()) || !key.m_150930_(LocksmithItems.KEY.get())) {
            return;
        }
        CompoundTag tag = keyRing.m_41784_();
        if (!tag.m_128441_("Keys")) {
            tag.m_128365_("Keys", (Tag)new ListTag());
        }
        ListTag keysNbt = tag.m_128437_("Keys", 10);
        ItemStack singleKey = key.m_41620_(1);
        CompoundTag keyTag = new CompoundTag();
        singleKey.m_41739_(keyTag);
        keysNbt.add(0, (Tag)keyTag);
    }

    private static boolean canAdd(ItemStack keyRing, ItemStack key) {
        if (!keyRing.m_150930_(LocksmithItems.KEYRING.get()) || !key.m_150930_(LocksmithItems.KEY.get())) {
            return false;
        }
        return keyRing.m_41783_() == null || keyRing.m_41783_().m_128425_("Keys", 9) && keyRing.m_41783_().m_128437_("Keys", 10).size() < 4;
    }
}

