/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.item;

import com.google.gson.JsonParseException;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.lock.types.KeyLock;
import gg.moonflower.locksmith.core.registry.LocksmithParticles;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import gg.moonflower.locksmith.core.registry.LocksmithTags;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class LockItem
extends Item {
    public LockItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        UUID lockId = KeyItem.getLockId(stack);
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (LockManager.get(level).getLock(LockPosition.of(pos)) != null || lockId == null || !level.m_8055_(pos).m_60620_(LocksmithTags.LOCKABLE_BLOCKS)) {
            return InteractionResult.PASS;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack lockStack = stack.m_41777_();
        lockStack.m_41764_(1);
        LockManager.get(level).addLock(new KeyLock(lockId, LockPosition.of(pos), lockStack));
        level.m_5594_(null, pos, LocksmithSounds.ITEM_LOCK_PLACE.get(), SoundSource.BLOCKS, 0.75f, 1.0f);
        level.m_8055_(pos).m_60771_((BlockGetter)level, pos, CollisionContext.m_82749_()).m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double d1 = Math.min(1.0, maxX - minX);
            double d2 = Math.min(1.0, maxY - minY);
            double d3 = Math.min(1.0, maxZ - minZ);
            int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.4)));
            int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.4)));
            int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.4)));
            ((ServerLevel)level).m_8767_((ParticleOptions)LocksmithParticles.LOCK_SPARK.get(), (double)pos.m_123341_() + minX + maxX / 2.0, (double)pos.m_123342_() + minY + maxY / 2.0, (double)pos.m_123343_() + minZ + maxZ / 2.0, i * j * k, (maxX - minX) / 4.0 + 0.0625, (maxY - minY) / 4.0 + 0.0625, (maxZ - minZ) / 4.0 + 0.0625, 0.0);
        });
        Player player = context.m_43723_();
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        LockItem.getKeyName(stack).ifPresent(name -> tooltipComponents.add((Component)new TranslatableComponent(this.m_5671_(stack) + ".key", new Object[]{name.m_6881_().m_130940_(ChatFormatting.GRAY)})));
        if (isAdvanced.m_7050_()) {
            UUID id = KeyItem.getLockId(stack);
            if (id == null) {
                return;
            }
            tooltipComponents.add((Component)new TextComponent("Lock Id: " + id).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public static Optional<Component> getKeyName(ItemStack stack) {
        if (!(stack.m_41720_() instanceof LockItem)) {
            return Optional.empty();
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128425_("KeyName", 8)) {
            return Optional.empty();
        }
        try {
            MutableComponent component = Component.Serializer.m_130701_((String)nbt.m_128461_("KeyName"));
            if (component != null) {
                return Optional.of(component);
            }
            nbt.m_128473_("KeyName");
        }
        catch (JsonParseException e) {
            nbt.m_128473_("KeyName");
        }
        return Optional.empty();
    }

    public static void setKeyName(ItemStack stack, @Nullable Component name) {
        if (!(stack.m_41720_() instanceof LockItem)) {
            return;
        }
        if (name == null) {
            stack.m_41749_("KeyName");
            return;
        }
        stack.m_41784_().m_128359_("KeyName", Component.Serializer.m_130703_((Component)name));
    }
}

