/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lock;

import com.mojang.serialization.DynamicOps;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.core.Locksmith;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockInteractionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component LOCKED = new TranslatableComponent("lock.locksmith.locked");

    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos pos = hitResult.m_82425_();
        LockPosition lockPosition = LockPosition.of(pos);
        AbstractLock lock = LockManager.get(level).getLock(lockPosition);
        if (lock == null || player.m_7500_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (((Boolean)Locksmith.CONFIG.enableLockpicking.get()).booleanValue() && lock.pick(player, level, lockPosition, stack, hand)) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (!(lock.onRightClick(player, level, stack, hitResult) || hand != InteractionHand.OFF_HAND && lock.onRightClick(player, level, player.m_21206_(), hitResult))) {
            player.m_5661_(LOCKED, true);
            if (level.m_5776_()) {
                player.m_6330_(LocksmithSounds.ITEM_LOCK_LOCKED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_6674_(hand);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onLeftClickBlock(Player player, Level level, InteractionHand hand, BlockPos pos, Direction direction) {
        AbstractLock lock = LockManager.get(level).getLock(LockPosition.of(pos));
        if (lock == null || player.m_7500_()) {
            return InteractionResult.PASS;
        }
        if (lock.onLeftClick(player, level, hand, pos, direction)) {
            return InteractionResult.PASS;
        }
        player.m_5661_(LOCKED, true);
        return InteractionResult.FAIL;
    }

    public static void onBreakBlock(Level level, BlockPos pos, BlockState state) {
        AbstractLock lock = LockManager.get(level).getLock(LockPosition.of(pos));
        if (lock == null) {
            return;
        }
        if (state.m_61138_((Property)ChestBlock.f_51479_) && state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
            Tag tag = (Tag)AbstractLock.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)lock).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
            if (!(tag instanceof CompoundTag)) {
                return;
            }
            CompoundTag lockTag = (CompoundTag)tag;
            lockTag.m_128365_("pos", (Tag)BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)lock.getPos().blockPosition().m_142300_(ChestBlock.m_51584_((BlockState)state))).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
            AbstractLock newLock = (AbstractLock)AbstractLock.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)lockTag).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
            LockManager.get(level).addLock(newLock);
            return;
        }
        LockManager.get(level).removeLock(lock.getPos().blockPosition(), pos, false);
    }
}

