/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lock;

import com.mojang.serialization.DynamicOps;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.BlockLockPosition;
import gg.moonflower.locksmith.api.lock.position.EntityLockPosition;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.network.LocksmithMessages;
import gg.moonflower.locksmith.common.network.play.ClientboundAddLocksPacket;
import gg.moonflower.locksmith.common.network.play.ClientboundDeleteLocksPacket;
import gg.moonflower.pollen.api.event.events.entity.player.server.ServerPlayerTrackingEvents;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ServerLockManager
extends SavedData
implements LockManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ChunkPos, ChunkLockData> locks = new HashMap<ChunkPos, ChunkLockData>();
    private final ChunkLockData entityLocks = new ChunkLockData();
    private final ServerLevel level;

    private ServerLockManager(ServerLevel level) {
        this.level = level;
    }

    private ServerLockManager(ServerLevel level, CompoundTag nbt) {
        this(level);
        ListTag chunks = nbt.m_128437_("Chunks", 10);
        for (int i = 0; i < chunks.size(); ++i) {
            CompoundTag lock = chunks.m_128728_(i);
            ChunkLockData data = new ChunkLockData();
            data.load(lock);
            this.locks.put(new ChunkPos(lock.m_128451_("X"), lock.m_128451_("Z")), data);
        }
        this.entityLocks.load(nbt.m_128469_("Entities"));
        this.entityLocks.locks.values().stream().map(AbstractLock::getPos).filter(EntityLockPosition.class::isInstance).map(EntityLockPosition.class::cast).forEach(pos -> pos.setEntity(() -> level.m_8791_(pos.getEntityId())));
    }

    public static ServerLockManager getOrCreate(ServerLevel level) {
        return (ServerLockManager)level.m_8895_().m_164861_(tag -> new ServerLockManager(level, (CompoundTag)tag), () -> new ServerLockManager(level), "locksmithLocks");
    }

    public static void init() {
        ServerPlayerTrackingEvents.START_TRACKING_CHUNK.register((player, chunk) -> {
            if (!(player.f_19853_ instanceof ServerLevel) || !(player instanceof ServerPlayer)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((ServerLevel)player.f_19853_).getLocks(chunk);
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((ServerPlayer)player, (PollinatedPacket)new ClientboundAddLocksPacket(locks, true));
        });
        ServerPlayerTrackingEvents.STOP_TRACKING_CHUNK.register((player, chunk) -> {
            if (!(player.f_19853_ instanceof ServerLevel) || !(player instanceof ServerPlayer)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((ServerLevel)player.f_19853_).getLocks(chunk);
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((ServerPlayer)player, (PollinatedPacket)new ClientboundDeleteLocksPacket(locks.stream().map(AbstractLock::getPos).collect(Collectors.toSet())));
        });
        ServerPlayerTrackingEvents.START_TRACKING_ENTITY.register((player, chunk) -> {
            if (!(player.f_19853_ instanceof ServerLevel) || !(player instanceof ServerPlayer)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((ServerLevel)((ServerLevel)player.f_19853_)).entityLocks.getLocks();
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((ServerPlayer)player, (PollinatedPacket)new ClientboundAddLocksPacket(locks, true));
        });
        ServerPlayerTrackingEvents.STOP_TRACKING_ENTITY.register((player, chunk) -> {
            if (!(player.f_19853_ instanceof ServerLevel) || !(player instanceof ServerPlayer)) {
                return;
            }
            Collection<AbstractLock> locks = ServerLockManager.getOrCreate((ServerLevel)((ServerLevel)player.f_19853_)).entityLocks.getLocks();
            if (locks.isEmpty()) {
                return;
            }
            LocksmithMessages.PLAY.sendTo((ServerPlayer)player, (PollinatedPacket)new ClientboundDeleteLocksPacket(locks.stream().map(AbstractLock::getPos).collect(Collectors.toSet())));
        });
    }

    private Collection<AbstractLock> getLocks(ChunkPos chunkPos) {
        ChunkLockData chunk = this.locks.get(chunkPos);
        if (chunk == null) {
            return Collections.emptySet();
        }
        return chunk.getLocks();
    }

    @Override
    @Nullable
    public AbstractLock getLock(LockPosition pos) {
        ChunkLockData chunk = this.get(pos, false);
        if (chunk == null) {
            return null;
        }
        AbstractLock lock = chunk.getLock(pos);
        if (lock != null) {
            return lock;
        }
        if (pos instanceof BlockLockPosition) {
            BlockPos offsetPos = LockManager.getLockPosition((Level)this.level, pos.blockPosition());
            if (!pos.blockPosition().equals((Object)offsetPos)) {
                return chunk.getLock(LockPosition.of(offsetPos));
            }
        }
        return null;
    }

    @Override
    public void addLock(AbstractLock data) {
        ChunkLockData lockData = this.get(data.getPos(), true);
        LockPosition pos = data.getPos();
        if (pos instanceof BlockLockPosition) {
            LocksmithMessages.PLAY.sendToTracking(this.level, new ChunkPos(pos.blockPosition()), (PollinatedPacket)new ClientboundAddLocksPacket(Collections.singleton(data), false));
        } else {
            LocksmithMessages.PLAY.sendToTracking(((EntityLockPosition)pos).getEntity(), (PollinatedPacket)new ClientboundAddLocksPacket(Collections.singleton(data), false));
        }
        lockData.addLock(data);
        this.m_77762_();
    }

    private ChunkLockData get(LockPosition pos, boolean create) {
        if (pos instanceof BlockLockPosition) {
            ChunkPos chunk = new ChunkPos(pos.blockPosition());
            ChunkLockData chunkData = this.locks.get(chunk);
            if (chunkData != null || !create) {
                return chunkData;
            }
            chunkData = new ChunkLockData();
            this.locks.put(chunk, chunkData);
            return chunkData;
        }
        return this.entityLocks;
    }

    private void removeLock(LockPosition pos, BlockPos clickPos, boolean drop) {
        ChunkLockData chunkData = this.get(pos, false);
        if (chunkData == null) {
            return;
        }
        AbstractLock lock = chunkData.removeLock(pos);
        if (lock == null) {
            return;
        }
        if (pos instanceof BlockLockPosition) {
            ItemStack lockStack;
            lock.onRemove((Level)this.level, pos.blockPosition(), clickPos);
            if (drop && !(lockStack = lock.getStack()).m_41619_()) {
                Block.m_49840_((Level)this.level, (BlockPos)clickPos, (ItemStack)lockStack);
            }
            LocksmithMessages.PLAY.sendToTracking(this.level, new ChunkPos(pos.blockPosition()), (PollinatedPacket)new ClientboundDeleteLocksPacket(Collections.singleton(pos)));
        } else {
            ItemStack lockStack;
            Entity entity = ((EntityLockPosition)pos).getEntity();
            lock.onRemove(entity);
            if (drop && !(lockStack = lock.getStack()).m_41619_()) {
                Block.m_49840_((Level)this.level, (BlockPos)clickPos, (ItemStack)lockStack);
            }
            LocksmithMessages.PLAY.sendToTracking(entity, (PollinatedPacket)new ClientboundDeleteLocksPacket(Collections.singleton(pos)));
        }
        this.m_77762_();
    }

    @Override
    public void removeLock(BlockPos pos, BlockPos clickPos, boolean drop) {
        this.removeLock(LockPosition.of(pos), clickPos, drop);
    }

    @Override
    public void removeLock(Entity entity, boolean drop) {
        this.removeLock(LockPosition.of(entity), entity.m_142538_(), drop);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag locksNbt = new ListTag();
        for (ChunkPos pos : this.locks.keySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("X", pos.f_45578_);
            tag.m_128405_("Z", pos.f_45579_);
            locksNbt.add((Object)this.locks.get(pos).save(tag));
        }
        nbt.m_128365_("Chunks", (Tag)locksNbt);
        nbt.m_128365_("Entities", (Tag)this.entityLocks.save(new CompoundTag()));
        return nbt;
    }

    private static class ChunkLockData {
        private final Map<LockPosition, AbstractLock> locks = new HashMap<LockPosition, AbstractLock>();

        private ChunkLockData() {
        }

        public void load(CompoundTag compoundTag) {
            ListTag tag = compoundTag.m_128437_("Locks", 10);
            for (int i = 0; i < tag.size(); ++i) {
                AbstractLock lock = (AbstractLock)AbstractLock.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128728_(i)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                this.locks.put(lock.getPos(), lock);
            }
        }

        public CompoundTag save(CompoundTag compoundTag) {
            ListTag list = new ListTag();
            for (AbstractLock lock : this.locks.values()) {
                list.add((Object)((Tag)AbstractLock.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)lock).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0))));
            }
            compoundTag.m_128365_("Locks", (Tag)list);
            return compoundTag;
        }

        public Collection<AbstractLock> getLocks() {
            return this.locks.values();
        }

        @Nullable
        public AbstractLock getLock(LockPosition pos) {
            return this.locks.get(pos);
        }

        public void addLock(AbstractLock lock) {
            this.locks.put(lock.getPos(), lock);
        }

        @Nullable
        public AbstractLock removeLock(LockPosition pos) {
            return this.locks.remove(pos);
        }
    }
}

