/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lock.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.locksmith.api.key.Key;
import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockType;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.menu.LockpickingMenu;
import gg.moonflower.locksmith.core.Locksmith;
import gg.moonflower.locksmith.core.registry.LocksmithItems;
import gg.moonflower.locksmith.core.registry.LocksmithLocks;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SerializableUUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class KeyLock
extends AbstractLock {
    public static final Codec<KeyLock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableUUID.f_123272_.fieldOf("id").forGetter(AbstractLock::getId), (App)LockPosition.CODEC.fieldOf("pos").forGetter(AbstractLock::getPos), (App)ItemStack.f_41582_.fieldOf("stack").forGetter(AbstractLock::getStack)).apply((Applicative)instance, KeyLock::new));
    private static final Component LOCK_PICKING = new TranslatableComponent("container.locksmith.lock_picking");

    public KeyLock(LockType type, UUID id, LockPosition pos, ItemStack stack) {
        super(type, id, pos, stack);
    }

    public KeyLock(UUID id, LockPosition pos, ItemStack stack) {
        this(LocksmithLocks.KEY.get(), id, pos, stack);
    }

    @Override
    public boolean canRemove(Player player, Level level, ItemStack stack) {
        return player.m_36341_() && (stack.m_41720_() == LocksmithItems.KEY.get() || stack.m_41720_() == LocksmithItems.KEYRING.get()) && ((Key)stack.m_41720_()).matchesLock(this.getId(), stack);
    }

    @Override
    public boolean canUnlock(Player player, Level level, ItemStack stack) {
        return player.m_7500_() || (stack.m_41720_() == LocksmithItems.KEY.get() || stack.m_41720_() == LocksmithItems.KEYRING.get()) && ((Key)stack.m_41720_()).matchesLock(this.getId(), stack);
    }

    @Override
    public boolean pick(Player player, Level level, final LockPosition pos, final ItemStack pickStack, final InteractionHand hand) {
        if (pickStack.m_41720_() != LocksmithItems.LOCKPICK.get()) {
            return false;
        }
        if (!level.m_5776_()) {
            player.m_5893_(new MenuProvider(){

                public Component m_5446_() {
                    return LOCK_PICKING;
                }

                public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
                    return new LockpickingMenu(containerId, LockPickingContext.server(KeyLock.this.getPos(), pos.blockPosition(), (ServerPlayer)player, pickStack, hand));
                }
            });
        }
        return true;
    }

    @Override
    public boolean onRightClick(Player player, Level level, ItemStack stack, BlockHitResult hitResult) {
        if (this.canUnlock(player, level, stack)) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            return true;
        }
        return false;
    }

    @Override
    public boolean onLeftClick(Player player, Level level, InteractionHand hand, BlockPos pos, Direction direction) {
        return (Boolean)Locksmith.CONFIG.allowLocksToBeBroken.get();
    }

    @Override
    public boolean onRightClick(Player player, Level level, ItemStack stack, Entity entity) {
        if (this.canUnlock(player, level, stack)) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            return true;
        }
        return false;
    }

    @Override
    public boolean onLeftClick(Player player, Level level, InteractionHand hand, Entity entity) {
        return false;
    }
}

