/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lockpicking;

import gg.moonflower.locksmith.api.lock.position.EntityLockPosition;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.common.lockpicking.ClientPickingContext;
import gg.moonflower.locksmith.common.lockpicking.ServerBlockPickingContext;
import gg.moonflower.locksmith.common.lockpicking.ServerEntityPickingContext;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class LockPickingContext {
    private static final byte ALL_PINS = 31;
    private byte pinStates = 0;
    private byte pickDamage = 0;

    protected LockPickingContext() {
    }

    public abstract void pick(int var1);

    public void reset() {
        this.pinStates = 0;
    }

    public abstract void stop(boolean var1);

    public abstract GameState getState();

    protected boolean areAllPinsSet() {
        return this.pinStates == 31;
    }

    public boolean getPinState(int pin) {
        if (pin < 0 || pin >= 5) {
            return false;
        }
        return (this.pinStates >> pin & 1) > 0;
    }

    public int getPickDamage() {
        return this.pickDamage;
    }

    public void setPinState(int pin, boolean set) {
        if (pin < 0 || pin >= 5) {
            return;
        }
        this.pinStates = (byte)(this.pinStates & ~(1 << pin));
        if (set) {
            this.pinStates = (byte)(this.pinStates | 1 << pin);
        }
    }

    public void setPickDamage(int pickDamage) {
        this.pickDamage = (byte)pickDamage;
    }

    public abstract boolean stillValid(Player var1);

    public static LockPickingContext client(int containerId) {
        return new ClientPickingContext(containerId);
    }

    public static LockPickingContext server(LockPosition pos, BlockPos clickPos, ServerPlayer player, ItemStack pickStack, InteractionHand pickHand) {
        return pos instanceof EntityLockPosition ? new ServerEntityPickingContext(((EntityLockPosition)pos).getEntity(), player, pickStack, pickHand) : new ServerBlockPickingContext(ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)pos.blockPosition()), clickPos, player, pickStack, pickHand);
    }

    public static enum GameState {
        RUNNING,
        SUCCESS,
        FAIL;

    }
}

