/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.lockpicking;

import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.network.LocksmithMessages;
import gg.moonflower.locksmith.common.network.play.ClientboundLockPickingPacket;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import gg.moonflower.locksmith.core.registry.LocksmithStats;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class ServerPickingContext
extends LockPickingContext {
    public static final int FAIL_WAIT_TIME = 10;
    public static final int FAIL_THRESHOLD = 10;
    protected final ServerPlayer player;
    protected final ItemStack pickStack;
    protected final InteractionHand pickHand;
    protected final Game game;
    protected int lastSetTime;
    protected LockPickingContext.GameState state;
    protected int stop;

    protected ServerPickingContext(ServerPlayer player, ItemStack pickStack, InteractionHand pickHand) {
        this.player = player;
        this.pickStack = pickStack;
        this.pickHand = pickHand;
        Random random = player.f_19853_.m_5822_();
        this.game = new Game(2, random);
        this.state = LockPickingContext.GameState.RUNNING;
        this.stop = 0;
        this.setPickDamage(pickStack.m_41773_());
    }

    protected abstract void playSound(SoundEvent var1);

    protected abstract void removeLock();

    @Override
    public void pick(int pin) {
        if (this.getPinState(pin)) {
            LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(pin, true));
            return;
        }
        if (this.game.shouldDrop(pin)) {
            this.playSound(LocksmithSounds.LOCK_PICKING_SET.get());
            this.setPinState(pin, true);
            this.game.next(this);
            if (this.areAllPinsSet()) {
                this.stop(true);
            }
        } else {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.game.reset();
        this.playSound(LocksmithSounds.LOCK_PICKING_PINS_DROP.get());
        this.pickStack.m_41622_(1, (LivingEntity)this.player, contextPlayer -> {
            this.state = LockPickingContext.GameState.FAIL;
            this.stop = this.player.f_19797_;
            this.playSound(LocksmithSounds.LOCK_PICKING_FAIL.get());
            LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.FAIL));
            contextPlayer.m_21190_(this.pickHand);
        });
        this.setPickDamage(this.pickStack.m_41619_() ? 2 : this.pickStack.m_41773_());
        this.player.f_36095_.m_38946_();
        super.reset();
        LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.RESET));
    }

    @Override
    public void stop(boolean success) {
        this.state = success ? LockPickingContext.GameState.SUCCESS : LockPickingContext.GameState.FAIL;
        this.stop = this.player.f_19797_;
        this.playSound(success ? LocksmithSounds.LOCK_PICKING_SUCCESS.get() : LocksmithSounds.LOCK_PICKING_FAIL.get());
        if (success) {
            LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.SUCCESS));
            this.player.m_36220_(LocksmithStats.PICK_LOCK);
            this.removeLock();
            return;
        }
        this.pickStack.m_41622_(1, (LivingEntity)this.player, contextPlayer -> contextPlayer.m_21190_(this.pickHand));
        this.setPickDamage(this.pickStack.m_41619_() ? 2 : this.pickStack.m_41773_());
        LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(ClientboundLockPickingPacket.Type.FAIL));
    }

    @Override
    public LockPickingContext.GameState getState() {
        return this.state;
    }

    @Override
    public void setPinState(int pin, boolean set) {
        if (pin < 0 || pin >= 5) {
            return;
        }
        super.setPinState(pin, set);
        if (this.player.f_19797_ - this.lastSetTime < 10) {
            this.playSound(LocksmithSounds.LOCK_PICKING_OVERSET.get());
            this.stop(false);
            return;
        }
        this.lastSetTime = this.player.f_19797_;
        LocksmithMessages.PLAY.sendTo(this.player, (PollinatedPacket)new ClientboundLockPickingPacket(pin, set));
    }

    @Override
    public boolean stillValid(Player player) {
        return this.player == player && (this.state == LockPickingContext.GameState.RUNNING || this.player.f_19797_ - this.stop < 10);
    }

    public static class Game {
        private final int[] droppingPins;
        private int droppingIndex;

        private Game(int complexity, Random random) {
            int size = Mth.m_14045_((int)complexity, (int)0, (int)4);
            ArrayList<Integer> pins = new ArrayList<Integer>(size);
            while (pins.size() < size) {
                pins.add(random.nextInt(5));
            }
            this.droppingPins = pins.stream().mapToInt(Integer::intValue).toArray();
            this.droppingIndex = -1;
        }

        private boolean isNonDropping(int pin) {
            return IntStream.of(this.droppingPins).noneMatch(dropping -> dropping == pin);
        }

        public void reset() {
            this.droppingIndex = -1;
        }

        public void next(LockPickingContext context) {
            if (this.droppingIndex >= 0) {
                ++this.droppingIndex;
            } else {
                for (int i = 0; i < 5; ++i) {
                    if (!this.isNonDropping(i) || context.getPinState(i)) continue;
                    return;
                }
                this.droppingIndex = 0;
            }
        }

        public boolean shouldDrop(int pin) {
            return this.droppingIndex == -1 ? this.isNonDropping(pin) : this.droppingPins[this.droppingIndex] == pin;
        }
    }
}

