/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.menu;

import com.mojang.datafixers.util.Pair;
import gg.moonflower.locksmith.common.item.KeyItem;
import gg.moonflower.locksmith.common.menu.LocksmithResultContainer;
import gg.moonflower.locksmith.common.recipe.LocksmithingRecipe;
import gg.moonflower.locksmith.core.registry.LocksmithBlocks;
import gg.moonflower.locksmith.core.registry.LocksmithMenus;
import gg.moonflower.locksmith.core.registry.LocksmithRecipes;
import gg.moonflower.locksmith.core.registry.LocksmithSounds;
import gg.moonflower.pollen.api.util.QuickMoveHelper;
import java.util.Optional;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class LocksmithingTableMenu
extends AbstractContainerMenu {
    public static final ResourceLocation EMPTY_SLOT_KEY = new ResourceLocation("locksmith", "item/empty_locksmithing_table_slot_key");
    private static final QuickMoveHelper MOVE_HELPER = new QuickMoveHelper().add(0, 4, 4, 36, true).add(4, 36, 0, 2, false);
    private final ContainerLevelAccess access;
    private final Player player;
    private final CraftingContainer craftSlots;
    private final LocksmithResultContainer resultSlots = new LocksmithResultContainer(2);
    private final Slot keyInputSlot;
    private final Slot inputSlot;
    private long lastSoundTime;
    private boolean partialTake;
    private boolean pendingTake;

    public LocksmithingTableMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, ContainerLevelAccess.f_39287_);
    }

    public LocksmithingTableMenu(int containerId, Inventory inventory, ContainerLevelAccess access) {
        super(LocksmithMenus.LOCKSMITHING_TABLE_MENU.get(), containerId);
        this.player = inventory.f_35978_;
        this.access = access;
        this.craftSlots = new CraftingContainer((AbstractContainerMenu)this, 1, 2);
        this.keyInputSlot = this.m_38897_(new Slot((Container)this.craftSlots, 0, 21, 17){

            public boolean m_5857_(ItemStack stack) {
                return KeyItem.isKey(stack) || KeyItem.isBlankKey(stack);
            }

            public int m_6641_() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_SLOT_KEY);
            }
        });
        this.inputSlot = this.m_38897_(new Slot((Container)this.craftSlots, 1, 21, 54));
        this.m_38897_(new LocksmithingResultSlot(0, 101, 35));
        this.m_38897_(new LocksmithingResultSlot(1, 131, 35));
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.m_38897_(new Slot((Container)inventory, y + x * 9 + 9, 8 + y * 18, 84 + x * 18));
            }
        }
        for (int hotbarIndex = 0; hotbarIndex < 9; ++hotbarIndex) {
            this.m_38897_(new Slot((Container)inventory, hotbarIndex, 8 + hotbarIndex * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return LocksmithingTableMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)LocksmithBlocks.LOCKSMITHING_TABLE.get());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(player, (Container)this.craftSlots));
        if (this.pendingTake) {
            this.access.m_39292_((level, blockPos) -> this.m_150411_(player, this.resultSlots));
        }
    }

    public ItemStack m_7648_(Player player, int slot) {
        return MOVE_HELPER.quickMoveStack((AbstractContainerMenu)this, player, slot);
    }

    public void m_6199_(Container inventory) {
        super.m_6199_(inventory);
        this.partialTake = this.resultSlots.m_8020_(0).m_41619_() ^ this.resultSlots.m_8020_(1).m_41619_();
        if (this.resultSlots.m_7928_() != null && ((LocksmithingRecipe)this.resultSlots.m_7928_()).getSecondResultItem().m_41619_()) {
            this.partialTake = false;
        }
        if (inventory == this.craftSlots) {
            this.createResult();
        }
    }

    public CraftingContainer getCraftSlots() {
        return this.craftSlots;
    }

    protected static void slotChangedCraftingGrid(int containerId, Level level, Player player, CraftingContainer container, LocksmithResultContainer resultContainer) {
        if (!level.m_5776_()) {
            LocksmithingRecipe recipe;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack leftResult = ItemStack.f_41583_;
            ItemStack rightResult = ItemStack.f_41583_;
            Optional optional = level.m_142572_().m_129894_().m_44015_(LocksmithRecipes.LOCKSMITHING_TYPE.get(), (Container)container, level);
            if (optional.isPresent() && resultContainer.m_40135_(level, serverPlayer, recipe = (LocksmithingRecipe)optional.get())) {
                leftResult = recipe.m_5874_((Container)container);
                rightResult = recipe.getSecondAssembledResult();
            }
            resultContainer.m_6836_(0, leftResult);
            resultContainer.m_6836_(1, rightResult);
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(containerId, 0, 2, leftResult));
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(containerId, 0, 3, rightResult));
        }
    }

    private void createResult() {
        if (this.partialTake) {
            return;
        }
        if (this.pendingTake && !this.resultSlots.m_7983_()) {
            return;
        }
        this.resultSlots.m_6836_(0, ItemStack.f_41583_);
        this.resultSlots.m_6836_(1, ItemStack.f_41583_);
        this.pendingTake = false;
        this.access.m_39292_((level, blockPos) -> LocksmithingTableMenu.slotChangedCraftingGrid(this.f_38840_, level, this.player, this.craftSlots, this.resultSlots));
    }

    class LocksmithingResultSlot
    extends Slot {
        private int removeCount;

        public LocksmithingResultSlot(int index, int x, int y) {
            super((Container)LocksmithingTableMenu.this.resultSlots, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public ItemStack m_6201_(int amount) {
            if (this.m_6657_()) {
                this.removeCount += Math.min(amount, this.m_7993_().m_41613_());
            }
            return super.m_6201_(amount);
        }

        public void m_142406_(Player player, ItemStack stack) {
            if (LocksmithingTableMenu.this.pendingTake) {
                if (LocksmithingTableMenu.this.resultSlots.m_7983_()) {
                    this.m_6654_();
                    LocksmithingTableMenu.this.pendingTake = false;
                    if (!player.f_19853_.m_5776_()) {
                        LocksmithingTableMenu.this.m_6199_((Container)LocksmithingTableMenu.this.craftSlots);
                    }
                }
                return;
            }
            if (LocksmithingTableMenu.this.resultSlots.m_8020_(0).m_41619_() ^ LocksmithingTableMenu.this.resultSlots.m_8020_(1).m_41619_()) {
                LocksmithingTableMenu.this.pendingTake = true;
            }
            LocksmithingTableMenu.this.keyInputSlot.m_6201_(1);
            LocksmithingTableMenu.this.inputSlot.m_6201_(1);
            this.m_5845_(stack);
            super.m_142406_(player, stack);
            LocksmithingTableMenu.this.access.m_39292_((level, pos) -> {
                long l = level.m_46467_();
                if (LocksmithingTableMenu.this.lastSoundTime != l) {
                    level.m_5594_(null, pos, LocksmithSounds.UI_LOCKSMITHING_TABLE_TAKE_RESULT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    LocksmithingTableMenu.this.lastSoundTime = l;
                }
            });
            super.m_142406_(player, stack);
        }

        protected void m_7169_(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.m_5845_(stack);
        }

        protected void m_5845_(ItemStack stack) {
            if (this.removeCount > 0) {
                stack.m_41678_(LocksmithingTableMenu.this.player.f_19853_, LocksmithingTableMenu.this.player, this.removeCount);
            }
            if (this.f_40218_ instanceof RecipeHolder) {
                ((RecipeHolder)this.f_40218_).m_8015_(LocksmithingTableMenu.this.player);
            }
            this.removeCount = 0;
        }
    }
}

