/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.locksmith.common.network.play.handler;

import gg.moonflower.locksmith.api.lock.AbstractLock;
import gg.moonflower.locksmith.api.lock.LockManager;
import gg.moonflower.locksmith.api.lock.position.BlockLockPosition;
import gg.moonflower.locksmith.api.lock.position.EntityLockPosition;
import gg.moonflower.locksmith.api.lock.position.LockPosition;
import gg.moonflower.locksmith.client.lock.ClientLockManager;
import gg.moonflower.locksmith.client.screen.LockPickingScreen;
import gg.moonflower.locksmith.common.lockpicking.LockPickingContext;
import gg.moonflower.locksmith.common.menu.LockpickingMenu;
import gg.moonflower.locksmith.common.network.play.ClientboundAddLocksPacket;
import gg.moonflower.locksmith.common.network.play.ClientboundDeleteLocksPacket;
import gg.moonflower.locksmith.common.network.play.ClientboundLockPickingPacket;
import gg.moonflower.locksmith.common.network.play.handler.LocksmithClientPlayPacketHandler;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class LocksmithClientPlayPacketHandlerImpl
implements LocksmithClientPlayPacketHandler {
    private Entity getLockEntity(ClientLevel level, EntityLockPosition pos) {
        UUID id = pos.getEntityId();
        for (Entity e : level.m_104735_()) {
            if (!e.m_142081_().equals(id)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void handleAddLocks(ClientboundAddLocksPacket msg, PollinatedPacketContext ctx) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        LockManager manager = LockManager.get((Level)level);
        ctx.enqueueWork(() -> {
            if (msg.isReplace()) {
                msg.getLocks().stream().filter(lock -> lock.getPos() instanceof BlockLockPosition).map(lock -> new ChunkPos(lock.getPos().blockPosition())).distinct().forEach(chunk -> ((ClientLockManager)manager).clearLocks((ChunkPos)chunk));
            }
            for (AbstractLock lock2 : msg.getLocks()) {
                if (lock2.getPos() instanceof EntityLockPosition) {
                    EntityLockPosition entityLockPos = (EntityLockPosition)lock2.getPos();
                    entityLockPos.setEntity(() -> this.getLockEntity(level, entityLockPos));
                }
                manager.addLock(lock2);
            }
        });
    }

    @Override
    public void handleDeleteLock(ClientboundDeleteLocksPacket msg, PollinatedPacketContext ctx) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (LockPosition pos : msg.getPositions()) {
            Entity e;
            if (pos instanceof BlockLockPosition) {
                ctx.enqueueWork(() -> LockManager.get((Level)level).removeLock(pos.blockPosition()));
                continue;
            }
            if (!(pos instanceof EntityLockPosition) || (e = this.getLockEntity(level, (EntityLockPosition)pos)) == null) continue;
            ctx.enqueueWork(() -> LockManager.get((Level)level).removeLock(e));
        }
    }

    @Override
    public void handleLockPicking(ClientboundLockPickingPacket msg, PollinatedPacketContext ctx) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof LockPickingScreen)) {
            return;
        }
        LockPickingContext context = ((LockpickingMenu)((LockPickingScreen)screen).m_6262_()).getContext();
        ctx.enqueueWork(() -> {
            switch (msg.getType()) {
                case SET: {
                    context.setPinState(msg.getPin(), msg.isSet());
                    ((LockPickingScreen)screen).lowerPick();
                    break;
                }
                case RESET: {
                    context.reset();
                    ((LockPickingScreen)screen).lowerPick();
                    break;
                }
                case SUCCESS: {
                    context.stop(true);
                    break;
                }
                case FAIL: {
                    context.stop(false);
                }
            }
        });
    }
}

